----------------------------------------------------------------------------
-- @Author: ViperGTS96-----------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------

function indoorCamPosition:vehicleCameraUpdate(superFunc, dt)
	local target = self.zoomTarget
	if self.zoomLimitedTarget >= 0 then
		target = math.min(self.zoomLimitedTarget, self.zoomTarget)
	end
	self.zoom = target +(math.pow(0.99579, dt) *(self.zoom - target))

	if self.lastInputValues.upDown ~= 0 then
		local value = self.lastInputValues.upDown * g_gameSettings:getValue(GameSettings.SETTING.CAMERA_SENSITIVITY)
		self.lastInputValues.upDown = 0
		value = g_gameSettings:getValue(GameSettings.SETTING.INVERT_Y_LOOK) and -value or value

		if self.isRotatable then
			if self.isActivated and not g_gui:getIsGuiVisible() then
				if self.limitRotXDelta > 0.001 then
					self.rotX = math.min(self.rotX - value, self.rotX)
				elseif self.limitRotXDelta < -0.001 then
					self.rotX = math.max(self.rotX - value, self.rotX)
				else
					self.rotX = self.rotX - value
				end

				if self.limit then
					self.rotX = math.min(self.rotMaxX, math.max(self.rotMinX, self.rotX))
				end
			end
		end
	end

	if self.lastInputValues.leftRight ~= 0 or self.autoRotateOverride then
		local value = self.autoRotateOverride or(self.lastInputValues.leftRight * g_gameSettings:getValue(GameSettings.SETTING.CAMERA_SENSITIVITY))
		self.lastInputValues.leftRight = 0

		if self.isRotatable then
			if self.isActivated and not g_gui:getIsGuiVisible() then
				self.rotY = self.rotY - value
			end
		end
	end

	if g_gameSettings:getValue(GameSettings.SETTING.IS_HEAD_TRACKING_ENABLED) and isHeadTrackingAvailable() and self.allowHeadTracking and self.headTrackingNode ~= nil then
		local tx, ty, tz = getHeadTrackingTranslation()
		local pitch, yaw, roll = getHeadTrackingRotation()
		if pitch ~= nil then
			local camParent = getParent(self.cameraNode)
			local ctx, cty, ctz
			local crx, cry, crz
			if camParent ~= 0 then
				ctx, cty, ctz = localToLocal(self.headTrackingNode, camParent, tx, ty, tz)
				crx, cry, crz = localRotationToLocal(self.headTrackingNode, camParent, pitch, yaw, roll)
			else
				ctx, cty, ctz = localToWorld(self.headTrackingNode, tx, ty, tz)
				crx, cry, crz = localRotationToWorld(self.headTrackingNode, pitch, yaw, roll)
			end

			setRotation(self.cameraNode, crx, cry, crz)
			setTranslation(self.cameraNode, ctx, cty, ctz)
		end
	else
		self:updateRotateNodeRotation()

		if self.limit then
            -- adjust rotation to avoid clipping with terrain
			if self.isRotatable and((self.useWorldXZRotation == nil and g_gameSettings:getValue(GameSettings.SETTING.USE_WORLD_CAMERA)) or self.useWorldXZRotation) then
				local numIterations = 4
				for _ = 1, numIterations do
					local transX, transY, transZ = self.transDirX * self.zoom, self.transDirY * self.zoom, self.transDirZ * self.zoom
					local x, y, z = localToWorld(getParent(self.cameraPositionNode), transX, transY, transZ)

					local terrainHeight = DensityMapHeightUtil.getHeightAtWorldPos(x, 0, z)

					local minHeight = terrainHeight + 0.9
					if y < minHeight then
						local h = math.sin(self.rotX) * self.zoom
						local h2 = h-(minHeight-y)
						self.rotX = math.asin(math.clamp(h2 / self.zoom, -1, 1))
						self:updateRotateNodeRotation()
					else
						break
					end
				end
			end

            -- adjust zoom to avoid collision with objects
			if self.allowTranslation then

				self.limitRotXDelta = 0
				local hasCollision, collisionDistance, nx, ny, nz, normalDotDir = self:getCollisionDistance()
				if hasCollision then
					local distOffset = 0.1
					if normalDotDir ~= nil then
						local absNormalDotDir = math.abs(normalDotDir)
						distOffset = MathUtil.lerp(1.2, 0.1, absNormalDotDir * absNormalDotDir * (3 - 2 * absNormalDotDir))
					end
					collisionDistance = math.max(collisionDistance-distOffset, 0.01)
					self.disableCollisionTime = g_currentMission.time + 400
					self.zoomLimitedTarget = collisionDistance
					if collisionDistance < self.zoom then
						self.zoom = collisionDistance
					end
					if self.isRotatable and nx ~= nil and collisionDistance < self.transMin then
						local _, lny, _ = worldDirectionToLocal(self.rotateNode, nx, ny, nz)
						if lny > 0.5 then
							self.limitRotXDelta = 1
						elseif lny < -0.5 then
							self.limitRotXDelta = -1
						end
					end
				else
					if self.disableCollisionTime <= g_currentMission.time then
						self.zoomLimitedTarget = -1
					end
				end
			end

		end
		self.transX, self.transY, self.transZ = self.transDirX * self.zoom, self.transDirY * self.zoom, self.transDirZ * self.zoom
		setTranslation(self.cameraPositionNode, self.transX, self.transY, self.transZ)
		------------------------------------------------------
		local adjustCamera = false;
		if self.vehicle.spec_indoorCamPosition ~= nil then
			local cam = self.vehicle:getActiveCamera();
			if self.vehicle.spec_indoorCamPosition.camera ~= nil then
				if cam == self.vehicle.spec_indoorCamPosition.camera then
					adjustCamera = true;
				end;
			end;
		end;

		if adjustCamera then
			local adjPos = self.vehicle.spec_indoorCamPosition.position;
			setTranslation(self.cameraPositionNode, self.transX + adjPos.x, self.transY + adjPos.y, self.transZ + adjPos.z);
		else
			setTranslation(self.cameraPositionNode, self.transX, self.transY, self.transZ);
		end;
		------------------------------------------------------
		if self.positionSmoothingParameter > 0 then

			local interpDt = g_physicsDt

			if self.vehicle.spec_rideable ~= nil then
				interpDt = self.vehicle.spec_rideable.interpolationDt
			end

			if g_server == nil then
                -- on clients, we interpolate the vehicles with dt, thus we need to use the same for camera interpolation
				interpDt = dt
			end
			if interpDt > 0 then
				local xlook, ylook, zlook = getWorldTranslation(self.rotateNode)
				local lookAtPos = self.lookAtPosition
				local lookAtLastPos = self.lookAtLastTargetPosition
				lookAtPos[1], lookAtPos[2], lookAtPos[3] = self:getSmoothed(self.lookAtSmoothingParameter, lookAtPos[1], lookAtPos[2], lookAtPos[3], xlook, ylook, zlook, lookAtLastPos[1], lookAtLastPos[2], lookAtLastPos[3], interpDt)
				lookAtLastPos[1], lookAtLastPos[2], lookAtLastPos[3] = xlook, ylook, zlook

				local x, y, z = getWorldTranslation(self.cameraPositionNode)
				local pos = self.position
				local lastPos = self.lastTargetPosition
				pos[1], pos[2], pos[3] = self:getSmoothed(self.positionSmoothingParameter, pos[1], pos[2], pos[3], x, y, z, lastPos[1], lastPos[2], lastPos[3], interpDt)
				lastPos[1], lastPos[2], lastPos[3] = x, y, z

				local upx, upy, upz = localDirectionToWorld(self.rotateNode, self:getTiltDirectionOffset(), 1, 0)
				local up = self.upVector
				local lastUp = self.lastUpVector
				up[1], up[2], up[3] = self:getSmoothed(self.positionSmoothingParameter, up[1], up[2], up[3], upx, upy, upz, lastUp[1], lastUp[2], lastUp[3], interpDt)
				lastUp[1], lastUp[2], lastUp[3] = upx, upy, upz

				self:setSeparateCameraPose()
			end
		end
	end

	if MathUtil.isNan(self.rotX) or MathUtil.isNan(self.rotY) or MathUtil.isNan(self.rotZ) then
		self:resetCamera()
	end;
end;
VehicleCamera.update = Utils.overwrittenFunction(VehicleCamera.update, indoorCamPosition.vehicleCameraUpdate);