----------------------------------------------------------------------------
-- @Author: ViperGTS96-----------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------

source(Utils.getFilename("src/indoorCamPosition.lua", g_currentModDirectory));
source(Utils.getFilename("src/vehicleCameraOverwrite.lua", g_currentModDirectory));

function installSpec()
	if g_specializationManager:getSpecializationByName("indoorCamPosition") == nil then
		if indoorCamPosition == nil then 
			print("ERROR: unable to find 'Mud' source file 'indoorCamPosition.lua'");
		else 
			for typeName, typeDef in pairs(g_vehicleTypeManager.types) do
				if typeDef ~= nil and (typeName ~= "locomotive") then 
					local isEnterable = false;	
					local isAnimated = false;
					local hasWheels = false;
					for name, spec in pairs(typeDef.specializationsByName) do 
						if name == "enterable" then 
							isEnterable = true;
						elseif name == "drivable" then 
							hasWheels = true;
						elseif name == "animatedVehicle" then 
							isAnimated = true;
						end;
					end;
					if isEnterable and isAnimated and hasWheels then
						 if typeDef.specializationsByName["indoorCamPosition"] == nil then
							table.insert(typeDef.specializations, indoorCamPosition);
							table.insert(typeDef.specializationNames, "indoorCamPosition");
							typeDef.specializationsByName["indoorCamPosition"] = indoorCamPosition;
						end;
					end;
				end;
			end;
		end;
	end;
end;

TypeManager.validateTypes = Utils.appendedFunction(TypeManager.validateTypes, installSpec);