
RMVehicle_Event = {}
local RMVehicle_Event_Event_mt = Class(RMVehicle_Event, Event)
InitEventClass(RMVehicle_Event, "RMVehicle_Event")
function RMVehicle_Event.emptyNew()
	return Event.new(RMVehicle_Event_Event_mt)
end
function RMVehicle_Event.new(vehicle, odometer, mode, odo, fuelusage, fuel, temp, rpm, ophours, globalSet)
	local self = RMVehicle_Event.emptyNew()
	self.vehicle = vehicle
	self.odometer = odometer
	self.mode = mode
	self.odo = odo
	self.fuelusage = fuelusage
	self.fuel = fuel
	self.temp = temp
	self.rpm = rpm
	self.ophours = ophours
	self.globalSet = globalSet
	return self
end
function RMVehicle_Event.readStream(self, streamId, connection)
	self.vehicle = NetworkUtil.readNodeObject(streamId)
	self.odometer = streamReadBool(streamId)
	self.mode = streamReadFloat32(streamId)
	self.odo = streamReadFloat32(streamId)
	self.fuelusage = streamReadBool(streamId)
	self.fuel = streamReadBool(streamId)
	self.temp = streamReadBool(streamId)
	self.rpm = streamReadBool(streamId)
	self.ophours = streamReadBool(streamId)
	self.globalSet = streamReadBool(streamId)
	self:run(connection)
end
function RMVehicle_Event.writeStream(self, streamId, _)
	NetworkUtil.writeNodeObject(streamId, self.vehicle)
	streamWriteBool(streamId, self.odometer)
	streamWriteFloat32(streamId, self.mode)
	streamWriteFloat32(streamId, self.odo)
	streamWriteBool(streamId, self.fuelusage)
	streamWriteBool(streamId, self.fuel)
	streamWriteBool(streamId, self.temp)
	streamWriteBool(streamId, self.rpm)
	streamWriteBool(streamId, self.ophours)
	streamWriteBool(streamId, self.globalSet)
end
function RMVehicle_Event.run(self, connection)
	if connection:getIsServer() then
		--g_messageCenter:publish(MessageType.RM_SETSAVE, self.vehicle)
	elseif self.vehicle ~= nil and (self.vehicle:getIsSynchronized() and self.vehicle.repaintVehicle ~= nil) then
		if self.globalSet then
			self.vehicle:globalsetRoadMaster(self.odometer, self.mode, self.odo, self.fuelusage, self.fuel, self.temp, self.rpm, self.ophours)
		else
			self.vehicle:setRoadMaster(self.vehicle, self.odometer, self.mode, self.odo, self.fuelusage, self.fuel, self.temp, self.rpm, self.ophours)
		end
		g_server:broadcastEvent(self)
		--g_messageCenter:publish(MessageType.RM_SETSAVE, self.vehicle)
		return
	end
end