
RoadMaster = {}
function RoadMaster.initSpecialization()
	local schema = Vehicle.xmlSchema
	schema:setXMLSpecializationType("roadMaster")
	local schemaSavegame = Vehicle.xmlSchemaSavegame
	local SavegameKey = string.format("vehicles.vehicle(?).%s.roadMaster", g_roadMasterModName)
	schemaSavegame:register(XMLValueType.BOOL, SavegameKey .. "#showOdometer", "")
	schemaSavegame:register(XMLValueType.FLOAT, SavegameKey .. "#displayMode", "")
	schemaSavegame:register(XMLValueType.FLOAT, SavegameKey .. "#odometer", "")
	schemaSavegame:register(XMLValueType.FLOAT, SavegameKey .. "#trip", "")
	schemaSavegame:register(XMLValueType.FLOAT, SavegameKey .. "#displayOdo", "")
	schemaSavegame:register(XMLValueType.BOOL, SavegameKey .. "#showFuelUsage", "")
	schemaSavegame:register(XMLValueType.BOOL, SavegameKey .. "#showFuel", "")
	schemaSavegame:register(XMLValueType.BOOL, SavegameKey .. "#showTemp", "")
	schemaSavegame:register(XMLValueType.BOOL, SavegameKey .. "#showRpm", "")
	schemaSavegame:register(XMLValueType.BOOL, SavegameKey .. "#gameOpHours", "")
	schemaSavegame:register(XMLValueType.FLOAT, SavegameKey .. "#averageSpeed", "")
	schemaSavegame:register(XMLValueType.FLOAT, SavegameKey .. "#operatingHours", "")
	schema:setXMLSpecializationType()
end
function RoadMaster.prerequisitesPresent(specializations)
	return true
end
function RoadMaster.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", RoadMaster)
	SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", RoadMaster)
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", RoadMaster)
	SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", RoadMaster)
	SpecializationUtil.registerEventListener(vehicleType, "saveToXMLFile", RoadMaster)
	SpecializationUtil.registerEventListener(vehicleType, "onReadStream", RoadMaster)
	SpecializationUtil.registerEventListener(vehicleType, "onWriteStream", RoadMaster)
	SpecializationUtil.registerEventListener(vehicleType, "onReadUpdateStream", RoadMaster)
	SpecializationUtil.registerEventListener(vehicleType, "onWriteUpdateStream", RoadMaster)
end
function RoadMaster.registerFunctions(vehicleType)
	SpecializationUtil.registerFunction(vehicleType, "getOdometer", RoadMaster.getOdometer)
	SpecializationUtil.registerFunction(vehicleType, "getTrip", RoadMaster.getTrip)
	SpecializationUtil.registerFunction(vehicleType, "getAverageSpeed", RoadMaster.getAverageSpeed)
	SpecializationUtil.registerFunction(vehicleType, "getshowOdometer", RoadMaster.getshowOdometer)
	SpecializationUtil.registerFunction(vehicleType, "getdisplayMode", RoadMaster.getdisplayMode)
	SpecializationUtil.registerFunction(vehicleType, "getdisplayOdo", RoadMaster.getdisplayOdo)
	SpecializationUtil.registerFunction(vehicleType, "getshowFuelUsage", RoadMaster.getshowFuelUsage)
	SpecializationUtil.registerFunction(vehicleType, "getshowFuel", RoadMaster.getshowFuel)
	SpecializationUtil.registerFunction(vehicleType, "getshowTemp", RoadMaster.getshowTemp)
	SpecializationUtil.registerFunction(vehicleType, "getshowRpm", RoadMaster.getshowRpm)
	SpecializationUtil.registerFunction(vehicleType, "getgameOpHours", RoadMaster.getgameOpHours)
	SpecializationUtil.registerFunction(vehicleType, "getOperatingHours", RoadMaster.getOperatingHours)
	SpecializationUtil.registerFunction(vehicleType, "setRoadMaster", RoadMaster.setRoadMaster)
	SpecializationUtil.registerFunction(vehicleType, "globalsetRoadMaster", RoadMaster.globalsetRoadMaster)
end
function RoadMaster:onLoad(savegame)
	if self.spec_roadMaster == nil then
		self.spec_roadMaster = {}
	end
	local spec = self.spec_roadMaster
	spec.showOdometer = true
	spec.displayMode = 2
	spec.odometer = 0
	spec.trip = 0
	spec.displayOdo = 1
	spec.showFuelUsage = true
	spec.showFuel = true
	spec.showTemp = true
	spec.showRpm = true
	spec.gameOpHours = false
	spec.averageSpeed = 0
	spec.operatingHours = 0
	spec.drivenDistanceNetworkThreshold = 10
    spec.odoDistanceSent = spec.odometer
	spec.tripDistanceSent = spec.trip
	spec.averageSpeedDistance = 0
	spec.averageSpeedTime = 0
	spec.averageSpeedDistanceSent = spec.averageSpeedDistance
	spec.dirtyFlag = self:getNextDirtyFlag()
	spec.actionEvents = {}
	spec.updateTimer = 0
	spec.motorTemperature = 20
	spec.fanEnabled = false
	spec.fanEnabledLast = false
	spec.fanEnableTemperature = 95
	spec.fanDisableTemperature = 85
	spec.lastFuelUsage = 0
	spec.lastDefUsage = 0
	spec.lastAirUsage = 0
end
function RoadMaster:onPostLoad(savegame)
	if savegame == nil then
		return
	end
	local spec = self.spec_roadMaster
	local key = string.format("%s.%s.%s", savegame.key, g_roadMasterModName, "roadMaster")
	spec.showOdometer = savegame.xmlFile:getValue(key .. "#showOdometer", true)
	spec.displayMode = savegame.xmlFile:getValue(key .. "#displayMode", 2)
	spec.odometer = savegame.xmlFile:getValue(key .. "#odometer", 0)
	spec.trip = savegame.xmlFile:getValue(key .. "#trip", 0)
	spec.displayOdo = savegame.xmlFile:getValue(key .. "#displayOdo", 1)
	spec.showFuelUsage = savegame.xmlFile:getValue(key .. "#showFuelUsage", true)
	spec.showFuel = savegame.xmlFile:getValue(key .. "#showFuel", true)
	spec.showTemp = savegame.xmlFile:getValue(key .. "#showTemp", true)
	spec.showRpm = savegame.xmlFile:getValue(key .. "#showRpm", true)
	spec.gameOpHours = savegame.xmlFile:getValue(key .. "#gameOpHours", false)
	spec.averageSpeed = savegame.xmlFile:getValue(key .. "#averageSpeed", 0)
	spec.operatingHours = savegame.xmlFile:getValue(key .. "#operatingHours", 0)
	spec.odoDistanceSent = spec.odometer
	spec.tripDistanceSent = spec.trip
end
function RoadMaster:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
	local spec = self.spec_roadMaster
	if self:getIsMotorStarted() then
		if self.isServer then
			if self.lastMovedDistance > 0.001 then
				spec.odometer = spec.odometer + self.lastMovedDistance
				if math.abs(spec.odometer - spec.odoDistanceSent) > spec.drivenDistanceNetworkThreshold then
					self:raiseDirtyFlags(spec.dirtyFlag)
					spec.odoDistanceSent = spec.odometer
				end
				spec.trip = spec.trip + self.lastMovedDistance
				if math.abs(spec.trip - spec.tripDistanceSent) > spec.drivenDistanceNetworkThreshold then
					self:raiseDirtyFlags(spec.dirtyFlag)
					spec.tripDistanceSent = spec.trip
				end
				spec.averageSpeedDistance = spec.averageSpeedDistance + self.lastMovedDistance
				spec.averageSpeedTime = spec.averageSpeedTime + dt / 3600000
				if math.abs(spec.averageSpeedDistance - spec.averageSpeedDistanceSent) > spec.drivenDistanceNetworkThreshold then
					self:raiseDirtyFlags(spec.dirtyFlag)
					spec.averageSpeedDistanceSent = spec.averageSpeedDistance
				end
			end
			if spec.averageSpeedDistance > 100 then
				local averageSpeedDistance = spec.averageSpeedDistance / 1000
				spec.averageSpeed = math.floor(averageSpeedDistance / spec.averageSpeedTime) or 0
				spec.averageSpeedDistance = 0
				spec.averageSpeedTime = 0
			end
			spec.operatingHours = spec.operatingHours + dt * g_currentMission.missionInfo.timeScale / 3600000
		end
	end
	local specM = self.spec_motorized
	spec.updateTimer = spec.updateTimer + dt
	if self.isServer and self.getIsMotorStarted ~= nil and self:getIsMotorStarted() then
		spec.motorTemperature = specM.motorTemperature.value
		spec.fanEnabled = specM.motorFan.enabled
		spec.lastFuelUsage = specM.lastFuelUsage
		spec.lastDefUsage = specM.lastDefUsage
		spec.lastAirUsage = specM.lastAirUsage
		spec.fanEnableTemperature = specM.motorFan.enableTemperature
		spec.fanDisableTemperature = specM.motorFan.disableTemperature
		if spec.updateTimer >= 1000 and spec.motorTemperature ~= self.spec_motorized.motorTemperature.valueSend then
			self:raiseDirtyFlags(spec.dirtyFlag)
		end
		if spec.fanEnabled ~= spec.fanEnabledLast then
			spec.fanEnabledLast = spec.fanEnabled
			self:raiseDirtyFlags(spec.dirtyFlag)
		end
	end
	if self.isClient and not self.isServer and self.getIsMotorStarted ~= nil and self:getIsMotorStarted() then
		specM.motorTemperature.value = spec.motorTemperature
		specM.motorFan.enabled = spec.fanEnabled
		specM.lastFuelUsage = spec.lastFuelUsage
		specM.lastDefUsage = spec.lastDefUsage
		specM.lastAirUsage = spec.lastAirUsage
		specM.motorFan.enableTemperature = spec.fanEnableTemperature
		specM.motorFan.disableTemperature = spec.fanDisableTemperature
	end
end
function RoadMaster:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
	if self.isClient then
		if self.getIsEntered ~= nil and self:getIsEntered() then
			local spec = self.spec_roadMaster
			if spec ~= nil and spec.actionEvents ~= nil then
				self:clearActionEventsTable(spec.actionEvents)
				if isActiveForInputIgnoreSelection then
					local set, actionEventIdSet = self:addActionEvent(spec.actionEvents, InputAction.ROADMASTER_SET, self, RoadMaster.roadMasterMenu, true, true, false, true, nil)
					if set then
						g_inputBinding:setActionEventTextPriority(actionEventIdSet, GS_PRIO_VERY_LOW)
						g_inputBinding:setActionEventTextVisibility(actionEventIdSet, true)
						g_inputBinding:setActionEventActive(actionEventIdSet, true)
					end
					local tripRes, actionEventIdTripRes = self:addActionEvent(spec.actionEvents, InputAction.ROADMASTER_TRIPRES, self, RoadMaster.tripReset, true, true, false, true, nil)
					if tripRes then
						g_inputBinding:setActionEventTextPriority(actionEventIdTripRes, GS_PRIO_VERY_LOW)
						g_inputBinding:setActionEventTextVisibility(actionEventIdTripRes, true)
						g_inputBinding:setActionEventActive(actionEventIdTripRes, true)
					end
				end
			end
		end
	end
end
function RoadMaster:roadMasterMenu() 
	if not self.isClient then
		return
	end
	if not g_currentMission.isSynchronizingWithPlayers then
		if not g_gui:getIsGuiVisible() then
			RoadMasterSettings.INSTANCE:setVehicle(self)
			RoadMasterSettings.show(self)
		end
	end
end
function RoadMaster:tripReset()
	local spec = self.spec_roadMaster
	spec.trip = 0
end
function RoadMaster:saveToXMLFile(xmlFile, key, usedModNames)
	local spec = self.spec_roadMaster
	xmlFile:setValue(key .. "#showOdometer", spec.showOdometer)
	xmlFile:setValue(key .. "#displayMode", spec.displayMode)
	xmlFile:setValue(key .. "#odometer", spec.odometer)
	xmlFile:setValue(key .. "#trip", spec.trip)
	xmlFile:setValue(key .. "#displayOdo", spec.displayOdo)
	xmlFile:setValue(key .. "#showFuelUsage", spec.showFuelUsage)
	xmlFile:setValue(key .. "#showFuel", spec.showFuel)
	xmlFile:setValue(key .. "#showTemp", spec.showTemp)
	xmlFile:setValue(key .. "#showRpm", spec.showRpm)
	xmlFile:setValue(key .. "#gameOpHours", spec.gameOpHours)
	xmlFile:setValue(key .. "#averageSpeed", spec.averageSpeed)
	xmlFile:setValue(key .. "#operatingHours", spec.operatingHours)
end
function RoadMaster:getOdometer()
	local spec = self.spec_roadMaster
	return spec.odometer
end
function RoadMaster:getTrip()
	local spec = self.spec_roadMaster
	return spec.trip
end
function RoadMaster:getAverageSpeed()
	local spec = self.spec_roadMaster
	return spec.averageSpeed
end
function RoadMaster:getshowOdometer()
	local spec = self.spec_roadMaster
	return spec.showOdometer
end
function RoadMaster:getdisplayMode()
	local spec = self.spec_roadMaster
	return spec.displayMode
end
function RoadMaster:getdisplayOdo()
	local spec = self.spec_roadMaster
	return spec.displayOdo
end
function RoadMaster:getshowFuelUsage()
	local spec = self.spec_roadMaster
	return spec.showFuelUsage
end
function RoadMaster:getshowFuel()
	local spec = self.spec_roadMaster
	return spec.showFuel
end
function RoadMaster:getshowTemp()
	local spec = self.spec_roadMaster
	return spec.showTemp
end
function RoadMaster:getshowRpm()
	local spec = self.spec_roadMaster
	return spec.showRpm
end
function RoadMaster:getgameOpHours()
	local spec = self.spec_roadMaster
	return spec.gameOpHours
end
function RoadMaster:getOperatingHours()
	local spec = self.spec_roadMaster
	return spec.operatingHours
end
function RoadMaster:setRoadMaster(vehicle, odometer, mode, odo, fuelusage, fuel, temp, rpm, ophours)
	if self.isServer then
		local spec = vehicle.spec_roadMaster
		local updated = false
		if odometer ~= spec.showOdometer then
			spec.showOdometer = odometer
			Logging.info("[RM] Settings 'showOdometer': %s", tostring(odometer))
			updated = true
		end
		if mode ~= spec.displayMode then
			spec.displayMode = mode
			Logging.info("[RM] Settings 'displayMode': %s", tostring(mode))
			updated = true
		end
		if odo ~= spec.displayOdo then
			spec.displayOdo = odo
			Logging.info("[RM] Settings 'displayOdo': %s", tostring(odo))
			updated = true
		end
		if fuelusage ~= spec.showFuelUsage then
			spec.showFuelUsage = fuelusage
			Logging.info("[RM] Settings 'showFuelUsage': %s", tostring(fuelusage))
			updated = true
		end
		if fuel ~= spec.showFuel then
			spec.showFuel = fuel
			Logging.info("[RM] Settings 'showFuel': %s", tostring(fuel))
			updated = true
		end
		if temp ~= spec.showTemp then
			spec.showTemp = temp
			Logging.info("[RM] Settings 'showTemp': %s", tostring(temp))
			updated = true
		end
		if rpm ~= spec.showRpm then
			spec.showRpm = rpm
			Logging.info("[RM] Settings 'showRpm': %s", tostring(rpm))
			updated = true
		end
		if ophours ~= spec.gameOpHours then
			spec.gameOpHours = ophours
			Logging.info("[RM] Settings 'gameOpHours': %s", tostring(ophours))
			updated = true
		end
		if updated then
			self:raiseDirtyFlags(spec.dirtyFlag)
		end
	end
end
function RoadMaster:globalsetRoadMaster(odometer, mode, odo, fuelusage, fuel, temp, rpm, ophours)
	if self.isServer then
		for _, vehicle in ipairs(g_currentMission.vehicleSystem.vehicles) do
			if vehicle.spec_roadMaster ~= nil then
				local spec = vehicle.spec_roadMaster
				spec.showOdometer = odometer
				spec.displayMode = mode
				spec.displayOdo = odo
				spec.showFuelUsage = fuelusage
				spec.showFuel = fuel
				spec.showTemp = temp
				spec.showRpm = rpm
				spec.gameOpHours = ophours
				vehicle:raiseDirtyFlags(spec.dirtyFlag)
			end
		end
		Logging.info("[RM] Global Settings 'showOdometer': %s", tostring(odometer))
		Logging.info("[RM] Global Settings 'displayMode': %s", tostring(mode))
		Logging.info("[RM] Global Settings 'displayOdo': %s", tostring(odo))
		Logging.info("[RM] Global Settings 'showFuelUsage': %s", tostring(fuelusage))
		Logging.info("[RM] Global Settings 'showFuel': %s", tostring(fuel))
		Logging.info("[RM] Global Settings 'showTemp': %s", tostring(temp))
		Logging.info("[RM] Global Settings 'showRpm': %s", tostring(rpm))
		Logging.info("[RM] Global Settings 'gameOpHours': %s", tostring(ophours))
	end
end
function RoadMaster:onReadStream(streamId, connection)
	if self.spec_roadMaster == nil then
		return
	end
	local spec = self.spec_roadMaster
	spec.showOdometer = streamReadBool(streamId)
	spec.displayMode = streamReadFloat32(streamId)
	spec.odometer = streamReadFloat32(streamId)
	spec.trip = streamReadFloat32(streamId)
	spec.displayOdo = streamReadFloat32(streamId)
	spec.showFuelUsage = streamReadBool(streamId)
	spec.showFuel = streamReadBool(streamId)
	spec.showTemp = streamReadBool(streamId)
	spec.showRpm = streamReadBool(streamId)
	spec.gameOpHours = streamReadBool(streamId)
	spec.averageSpeed = streamReadFloat32(streamId)
	spec.operatingHours = streamReadFloat32(streamId)
	spec.motorTemperature = streamReadFloat32(streamId)
	spec.fanEnabled = streamReadBool(streamId)
	spec.fanEnableTemperature = streamReadFloat32(streamId)
	spec.fanDisableTemperature = streamReadFloat32(streamId)
	spec.lastFuelUsage = streamReadFloat32(streamId)
	spec.lastDefUsage = streamReadFloat32(streamId)
	spec.lastAirUsage = streamReadFloat32(streamId)
	--self:setRoadMaster(self, spec.showOdometer, spec.displayMode, spec.displayOdo, spec.showFuelUsage, spec.showFuel, spec.showTemp, spec.showRpm, spec.gameOpHours)
end
function RoadMaster:onWriteStream(streamId, connection)
	if self.spec_roadMaster == nil then
		return
	end
	local spec = self.spec_roadMaster
	streamWriteBool(streamId, spec.showOdometer)
	streamWriteFloat32(streamId, spec.displayMode)
	streamWriteFloat32(streamId, spec.odometer)
	streamWriteFloat32(streamId, spec.trip)
	streamWriteFloat32(streamId, spec.displayOdo)
	streamWriteBool(streamId, spec.showFuelUsage)
	streamWriteBool(streamId, spec.showFuel)
	streamWriteBool(streamId, spec.showTemp)
	streamWriteBool(streamId, spec.showRpm)
	streamWriteBool(streamId, spec.gameOpHours)
	streamWriteFloat32(streamId, spec.averageSpeed)
	streamWriteFloat32(streamId, spec.operatingHours)
	streamWriteFloat32(streamId, spec.motorTemperature)
	streamWriteBool(streamId, spec.fanEnabled)
	streamWriteFloat32(streamId, spec.fanEnableTemperature)
	streamWriteFloat32(streamId, spec.fanDisableTemperature)
	streamWriteFloat32(streamId, spec.lastFuelUsage)
	streamWriteFloat32(streamId, spec.lastDefUsage)
	streamWriteFloat32(streamId, spec.lastAirUsage)
end
function RoadMaster:onReadUpdateStream(streamId, timestamp, connection)
	if connection.isServer then
		local spec = self.spec_roadMaster
		if streamReadBool(streamId) then
			spec.showOdometer = streamReadBool(streamId)
			spec.displayMode = streamReadFloat32(streamId)
			spec.odometer = streamReadFloat32(streamId)
			spec.trip = streamReadFloat32(streamId)
			spec.displayOdo = streamReadFloat32(streamId)
			spec.showFuelUsage = streamReadBool(streamId)
			spec.showFuel = streamReadBool(streamId)
			spec.showTemp = streamReadBool(streamId)
			spec.showRpm = streamReadBool(streamId)
			spec.gameOpHours = streamReadBool(streamId)
			spec.averageSpeed = streamReadFloat32(streamId)
			spec.operatingHours = streamReadFloat32(streamId)
			spec.motorTemperature = streamReadFloat32(streamId)
			spec.fanEnabled = streamReadBool(streamId)
			spec.fanEnableTemperature = streamReadFloat32(streamId)
			spec.fanDisableTemperature = streamReadFloat32(streamId)
			spec.lastFuelUsage = streamReadFloat32(streamId)
			spec.lastDefUsage = streamReadFloat32(streamId)
			spec.lastAirUsage = streamReadFloat32(streamId)
			--self:setRoadMaster(self, spec.showOdometer, spec.displayMode, spec.displayOdo, spec.showFuelUsage, spec.showFuel, spec.showTemp, spec.showRpm, spec.gameOpHours)
		end
	end
end
function RoadMaster:onWriteUpdateStream(streamId, connection, dirtyMask)
	if not connection.isServer then
		local spec = self.spec_roadMaster
		if streamWriteBool(streamId, bitAND(dirtyMask, spec.dirtyFlag) ~= 0) then
			streamWriteBool(streamId, spec.showOdometer)
			streamWriteFloat32(streamId, spec.displayMode)
			streamWriteFloat32(streamId, spec.odometer)
			streamWriteFloat32(streamId, spec.trip)
			streamWriteFloat32(streamId, spec.displayOdo)
			streamWriteBool(streamId, spec.showFuelUsage)
			streamWriteBool(streamId, spec.showFuel)
			streamWriteBool(streamId, spec.showTemp)
			streamWriteBool(streamId, spec.showRpm)
			streamWriteBool(streamId, spec.gameOpHours)
			streamWriteFloat32(streamId, spec.averageSpeed)
			streamWriteFloat32(streamId, spec.operatingHours)
			streamWriteFloat32(streamId, spec.motorTemperature)
			streamWriteBool(streamId, spec.fanEnabled)
			streamWriteFloat32(streamId, spec.fanEnableTemperature)
			streamWriteFloat32(streamId, spec.fanDisableTemperature)
			streamWriteFloat32(streamId, spec.lastFuelUsage)
			streamWriteFloat32(streamId, spec.lastDefUsage)
			streamWriteFloat32(streamId, spec.lastAirUsage)
			self.spec_motorized.motorTemperature.valueSend = spec.motorTemperature
			self.spec_motorized.motorFan.enabled = spec.fanEnabled
			self.spec_motorized.motorFan.enableTemperature = spec.fanEnableTemperature
			self.spec_motorized.motorFan.disableTemperature = spec.fanDisableTemperature
		end
	end
end
function RoadMaster:RM_drawSpeedMeter(superFunc, p178, p179)
	local p177 = self
	local v180 = p177.vehicle
	if v180 ~= nil then
		local v181 = g_gameSettings:getValue(GameSettings.SETTING.USE_MILES)
		local v182 = g_gameSettings:getValue(GameSettings.SETTING.HUD_SPEED_GAUGE)
		local v183 = v180.spec_motorized
		if v183.forceSpeedHudDisplay then
			v182 = SpeedMeterDisplay.GAUGE_MODE_SPEED
		elseif v183.forceRpmHudDisplay then
			v182 = SpeedMeterDisplay.GAUGE_MODE_RPM
		end
		local v184 = v180:getLastSpeed()
		local v185 = v184 * v180.spec_motorized.speedDisplayScale
		local v186 = math.clamp(v185, 0, 999)
		local v187 = v186 < 0.5 and 0 or v186
		local v188 = g_i18n:getSpeed(v187)
		local v189 = math.floor(v188)
		local v190 = v188 - v189
		if math.abs(v190) > 0.5 then
			v189 = v189 + 1
		end
		local v191 = v180:getMotor()
		local v192 = false
		local v193, v194, v195, v196, v197
		if v182 == SpeedMeterDisplay.GAUGE_MODE_RPM then
			v193 = p177.rpmUnitText
			v194 = v191:getMinRpm()
			v195 = v191:getMaxRpm()
			v196 = v180:getMotorRpmReal()
			v197 = 200
		else
			v193 = p177.kmhUnitText
			local v198
			if v181 then
				v193 = p177.mphUnitText
				v198 = 0.621371
			else
				v198 = 1
			end
			v195 = v191:getMaximumForwardSpeed() * 3.6 * v198
			v196 = v184 * v198
			v194 = 0
			v197 = 5
			v192 = true
		end
		local v199 = (v195 - v194) / 8 / v197
		local v200 = math.ceil(v199) * v197
		local v201 = v194 / v197
		local v202 = math.floor(v201) * v197 - v200
		local v203 = v195 / v197
		local v204 = math.floor(v203) * v197 + v200
		if not v192 then
			v194 = v202
		end
		p177.lastGaugeValue = p177.lastGaugeValue * 0.95 + v196 * 0.05
		local v205 = p177.speedIndicatorBg.width * 0.5
		local v206 = HUD.COLOR.INACTIVE
		local v207 = HUD.COLOR.ACTIVE
		for v208 = SpeedMeterDisplay.NUMBER_OF_INDICATORS, 1, -1 do
			local v209 = v208 * 0.17453292519943295 + -0.6108652381980153
			local v210 = math.cos(v209)
			local v211 = math.sin(v209)
			local v212 = p178 + v210 * p177.speedGaugeRadiusX - v205
			local v213 = p179 + v211 * p177.speedGaugeRadiusY - 0
			p177.speedIndicatorBg:setPosition(v212, v213)
			p177.speedIndicatorBg:setRotation(v209 - 1.5707963267948966, v205, 0)
			local v214 = MathUtil.lerp(v194, v204, 1 - v208 / SpeedMeterDisplay.NUMBER_OF_INDICATORS)
			local v215, v216, v217, v218
			if v196 > 0.5 and v214 < v196 then
				v215 = v207[1]
				v216 = v207[2]
				v217 = v207[3]
				v218 = v207[4]
			else
				v215 = v206[1]
				v216 = v206[2]
				v217 = v206[3]
				v218 = v206[4]
			end
			p177.speedIndicatorBg:setColor(v215, v216, v217, v218)
			p177.speedIndicatorBg:render()
		end
		setTextColor(1, 1, 1, 1)
		setTextAlignment(RenderText.ALIGN_CENTER)
		for v219 = 1, 10 do
			local v220 = p177.gaugeTextOffsets[v219]
			local v221 = p178 + v220.offsetX
			local v222 = p179 + v220.offsetY
			setTextAlignment(v220.alignment)
			setTextBold(true)
			local v223 = MathUtil.lerp(v194, v204, (v219 - 1) / 9)
			if v182 == SpeedMeterDisplay.GAUGE_MODE_RPM then
				v223 = v223 / 100
			end
			local v224 = string.format("%d", v223)
			renderText(v221, v222, p177.gaugeUnitTextSize, v224)
		end
		local v225 = p178 + p177.gaugeUnitOffsetX
		local v226 = p179 + p177.gaugeUnitOffsetY
		setTextRotation(0.5235987755982988, v225, v226)
		setTextBold(true)
		setTextAlignment(RenderText.ALIGN_CENTER)
		setTextColor(v207[1], v207[2], v207[3], v207[4])
		renderText(v225, v226, p177.gaugeUnitTextSize, v193)
		setTextColor(1, 1, 1, 1)
		if v182 == SpeedMeterDisplay.GAUGE_MODE_RPM then
			local v227 = p178 + p177.gaugeFactorOffsetX
			local v228 = p179 + p177.gaugeFactorOffsetY
			setTextRotation(-0.5235987755982988, v227, v228)
			renderText(v227, v228, p177.gaugeFactorTextSize, "x100")
		end
		setTextRotation(0, 0, 0)
		local v229 = p178 + p177.speedTextOffsetX
		local v230 = p179 + p177.speedTextOffsetY
		setTextBold(true)
		renderText(v229, v230, p177.speedTextSize, string.format("%1d", v189))
		local v231 = utf8ToUpper(g_i18n:getSpeedMeasuringUnit())
		local v232 = p178 + p177.speedUnitTextOffsetX
		local v233 = p179 + p177.speedUnitTextOffsetY
		setTextColor(v207[1], v207[2], v207[3], v207[4])
		renderText(v232, v233, p177.speedUnitTextSize, v231)
		setTextColor(1, 1, 1, 1)
		local v234 = p178 + p177.workingHoursSeperatorOffsetX
		local v235 = p179 + p177.workingHoursSeperatorOffsetY
		local v236 = v234 + p177.seperatorWidth
		drawLine2D(v234, v235, v236, v235, g_pixelSizeY, v207[1], v207[2], v207[3], v207[4])
		local v237 = p178 + p177.workingHoursTextOffsetX
		local v238 = p179 + p177.workingHoursTextOffsetY
		if v180.operatingTime == nil then
			setTextColor(1, 1, 1, 1)
			renderText(v237, v238, p177.workingHoursTextSize, "-/-")
		else
			local v239 = v180.operatingTime / 60000
			local v240 = v239 / 60
			local v241 = math.floor(v240)
			local v242 = (v239 - v241 * 60) / 6
			local v243 = math.floor(v242)
			if v180.spec_roadMaster ~= nil then
				p177.workingHours:setColor(unpack(HUD.COLOR.ACTIVE))
				if v180:getgameOpHours() then
					v239 = v180.spec_roadMaster.operatingHours
					v241 = math.floor(v239)
					v242 = (v239 - v241) * 60 
					v243 = math.floor(v242 / 10)
					p177.workingHours:setColor(unpack({0.0097, 0.4287, 0.6445, 1}))
				end
			end
			setTextAlignment(RenderText.ALIGN_RIGHT)
			setTextColor(1, 1, 1, 0.3)
			renderText(v237, v238, p177.workingHoursTextSize, string.format("%03d.%dh", v241, v243))
			setTextColor(1, 1, 1, 1)
			renderText(v237, v238, p177.workingHoursTextSize, string.format("%d.%dh", v241, v243))
		end
		p177.workingHours:setPosition(p178 + p177.workingHoursOffsetX, p179 + p177.workingHoursOffsetY)
		p177.workingHours:render()
		setTextAlignment(RenderText.ALIGN_LEFT)
		local v244 = p178 + p177.cruiseControlSeperatorOffsetX
		local v245 = p179 + p177.cruiseControlSeperatorOffsetY
		local v246 = v244 + p177.seperatorWidth
		drawLine2D(v244, v245, v246, v245, g_pixelSizeY, v207[1], v207[2], v207[3], v207[4])
		local v247, v248 = p177.vehicle:getCruiseControlDisplayInfo()
		local v249 = string.format("%d", g_i18n:getSpeed(v247))
		if v248 then
			setTextColor(v207[1], v207[2], v207[3], v207[4])
		else
			setTextColor(1, 1, 1, 1)
		end
		local v250 = p178 + p177.cruiseControlTextOffsetX
		local v251 = p179 + p177.cruiseControlTextOffsetY
		renderText(v250, v251, p177.cruiseControlTextSize, (tostring(v249)))
		p177.cruiseControl:setPosition(p178 + p177.cruiseControlOffsetX, p179 + p177.cruiseControlOffsetY)
		p177.cruiseControl:render()
	end
end
SpeedMeterDisplay.drawSpeedMeter = Utils.overwrittenFunction(SpeedMeterDisplay.drawSpeedMeter, RoadMaster.RM_drawSpeedMeter)