
RoadMasterHUD = {}
local RoadMasterHUD_mt = Class(RoadMasterHUD, HUDDisplay)
RoadMasterHUD.COLOR = {
	TEXT = { 1, 1, 1, 1 },
	TEXT_BACKGROUND = { 1, 1, 1, 0.3 }
}
function RoadMasterHUD:new()
	local self = RoadMasterHUD:superClass().new(RoadMasterHUD_mt)
	self.vehicle = nil
	self.isVehicleDrawSafe = false
	self.modDirectory = g_roadMasterDirectory
	g_overlayManager:addTextureConfigFile(self.modDirectory .. "images/hud/plusdashboard.xml", "plusdashboard")
	self.pipe = g_overlayManager:createOverlay("plusdashboard.pipe", 0, 0, 0, 0)
	self.pipe:setVisible(false)
	self.pipeLampUpdate = 0
	self.pipeLampBlinkState = nil
	self.StrawSwathLamp = g_overlayManager:createOverlay("plusdashboard.lamp", 0, 0, 0, 0)
	self.hSSLampUpdate = 0
	self.hSSLampBlinkState = nil
	self.odometerBg = g_overlayManager:createOverlay("plusdashboard.odometer", 0, 0, 0, 0)
	self.fuelBg = g_overlayManager:createOverlay("plusdashboard.fuelbg", 0, 0, 0, 0)
	self.fuelUsageUpdate = 0
	self.fuelUsage = 0
	self.fuelUpdate = 0
	self.fuelLevels = {}
	self.lastfuelUsageText1 = ""
	self.lastfuelUsageText2 = ""
	self.lastFuelText = ""
	self.updateFuelInterval = 500
	self.updateFuelUsageInterval = 500
	return self
end
function RoadMasterHUD:delete()
	if self.vehicle ~= nil then
		self.vehicle = nil
		self.fuelLevels = {}
		self.lastfuelUsageText1 = ""
		self.lastfuelUsageText2 = ""
		self.lastFuelText = ""
		self.updateFuelInterval = 500
		self.updateFuelUsageInterval = 500
	end
	self.isVehicleDrawSafe = false
	self.pipe:delete()
	self.StrawSwathLamp:delete()
	self.odometerBg:delete()
	self.fuelBg:delete()
	RoadMasterHUD:superClass().delete(self)
end
function RoadMasterHUD:storeScaledValues()
	self.rm_odometerTextOffsetX, self.rm_odometerTextOffsetY = self:scalePixelValuesToScreenVector(-22, -41)
	self.rm_tripTextOffsetX, self.rm_tripTextOffsetY = self:scalePixelValuesToScreenVector(-8, -41)
	self.rm_odometerTextSize = self:scalePixelToScreenHeight(14)
	self.rm_tripOffsetX, self.rm_tripOffsetY = self:scalePixelValuesToScreenVector(-28, -30)
	self.rm_tripSize = self:scalePixelToScreenHeight(9)
	self.rm_UnitOffsetX, self.rm_tripUnitOffsetY = self:scalePixelValuesToScreenVector(-20, 0)
	self.rm_tempTextOffsetX, self.rm_tempTextOffsetY = self:scalePixelValuesToScreenVector(52, -59)
	self.rm_tempTextSize = self:scalePixelToScreenHeight(10)
	self.rm_rpmTextOffsetX, self.rm_rpmTextOffsetY = self:scalePixelValuesToScreenVector(-54, -59)
	self.rm_rpmTextSize = self:scalePixelToScreenHeight(10)
	self.rm_fuelTextOffsetX, self.rm_fuelTextOffsetY = self:scalePixelValuesToScreenVector(8, 4)
	self.rm_fuelTextSize = self:scalePixelToScreenHeight(13)
	self.pipeOffsetX, self.pipeOffsetY = self:scalePixelValuesToScreenVector(-37, 10)
	local pipeWidth, pipeHeight = self:scalePixelValuesToScreenVector(32, 16)
	self.pipe:setDimension(pipeWidth, pipeHeight)
	self.hSSLampOffsetX, self.hSSLampOffsetY = self:scalePixelValuesToScreenVector(-28, -3)
	local hSSLampWidth, hSSLampHeight = self:scalePixelValuesToScreenVector(10, 10)
	self.StrawSwathLamp:setDimension(hSSLampWidth, hSSLampHeight)
	self.rm_odometerBgTextOffsetX, self.rm_odometerBgTextOffsetY = self:scalePixelValuesToScreenVector(-99, 8)
	self.odometerOffsetX, self.odometerOffsetY = self:scalePixelValuesToScreenVector(-36, 28)
	local odometerWidth, odometerHeight = self:scalePixelValuesToScreenVector(156, 26)
	self.odometerBg:setDimension(odometerWidth, odometerHeight)
	self.odometerTextOffsetX, self.odometerTextOffsetY = self:scalePixelValuesToScreenVector(-22, 25)
	local odoSeperatorOffsetX, odoSeperatorOffsetY = self:scalePixelValuesToScreenVector(-43, 23)
	self.odoSeperatorOffsetX = odoSeperatorOffsetX
	self.odoSeperatorOffsetY = odoSeperatorOffsetY
	self.odoSeperatorWidth = self:scalePixelToScreenWidth(86)
	self.rm_fuelBgTextOffsetX, self.rm_fuelBgTextOffsetY = self:scalePixelValuesToScreenVector(-68, 19)
	self.fuelBgOffsetX, self.fuelBgOffsetY = self:scalePixelValuesToScreenVector(-231, 25)
	local fuelBgWidth, fuelBgHeight = self:scalePixelValuesToScreenVector(96, 20)
	self.fuelBg:setDimension(fuelBgWidth, fuelBgHeight)
end
function RoadMasterHUD:setVehicle(vehicle)
	self.vehicle = nil
	self.fuelLevels = {}
	self.lastfuelUsageText1 = ""
	self.lastfuelUsageText2 = ""
	self.lastFuelText = ""
	self.updateFuelInterval = 50
	self.updateFuelUsageInterval = 50
	local hasVehicle = vehicle ~= nil
	local isMotorized = hasVehicle and vehicle.spec_motorized ~= nil
	if hasVehicle and isMotorized then
		self.vehicle = vehicle
	end
	if self.vehicle and self.vehicle.getConsumerFillUnitIndex ~= nil then
		self.hasDiesel   = self.vehicle:getConsumerFillUnitIndex(FillType.DIESEL) ~= nil
		self.hasElectric = self.vehicle:getConsumerFillUnitIndex(FillType.ELECTRICCHARGE) ~= nil
		self.hasMethane  = self.vehicle:getConsumerFillUnitIndex(FillType.METHANE) ~= nil
	end
	self:setVisible(self.vehicle ~= nil)
	self.isVehicleDrawSafe = false
end
function RoadMasterHUD:update(dt)
	RoadMasterHUD:superClass().update(self, dt)
	if self.vehicle ~= nil then
		self.isVehicleDrawSafe = true
	else
		self.isVehicleDrawSafe = false	
	end
	if self.vehicle ~= nil and self.vehicle.spec_pipe ~= nil then
		if self.vehicle:getCurrentPipeState() == 0 then
			if self.pipeLampBlinkState == nil then
				self.pipe:setColor(unpack({1, 0.4287, 0.0006, 1}))
			end
			self.pipeLampUpdate = self.pipeLampUpdate + dt
			local updateInterval = 550
			if self.pipeLampUpdate >= updateInterval then
				self.pipeLampUpdate = 0
				if self.pipeLampBlinkState then
					self.pipe:setColor(unpack(RoadMasterHUD.COLOR.TEXT_BACKGROUND))
					self.pipeLampBlinkState = false
				else
					self.pipe:setColor(unpack({1, 0.4287, 0.0006, 1}))
					self.pipeLampBlinkState = true
				end
			end
		else
			self.pipeLampBlinkState = nil
		end
	end
	if self.vehicle ~= nil then
		local specCombine = self.vehicle.spec_combine
		if specCombine ~= nil then
			local animationTime = self.vehicle:getAnimationTime(specCombine.chopper.animName)
			if animationTime > 0 and animationTime < 1 then
				if self.hSSLampBlinkState == nil then
					self.StrawSwathLamp:setColor(unpack({1, 0.4287, 0.0006, 1}))
				end
				self.hSSLampUpdate = self.hSSLampUpdate + dt
				local updateInterval = 550
				if self.hSSLampUpdate >= updateInterval then
					self.hSSLampUpdate = 0
					if self.hSSLampBlinkState then
						self.StrawSwathLamp:setColor(unpack({1, 0.4287, 0.0006, 1}))
						self.hSSLampBlinkState = false
					else
						self.hSSLampBlinkState = true
						self.StrawSwathLamp:setColor(unpack(RoadMasterHUD.COLOR.TEXT_BACKGROUND))
					end
				end
			else
				self.hSSLampBlinkState = nil
			end
		end
	end
	if self.vehicle ~= nil then
		local motorState = self.vehicle:getMotorState()
		if (self.hasDiesel or self.hasElectric or self.hasMethane) and (motorState == MotorState.ON or motorState == MotorState.STARTING) and self.vehicle.spec_fillUnit ~= nil then
			if self.vehicle.spec_roadMaster.showFuelUsage then
				self.fuelUsageUpdate = self.fuelUsageUpdate + dt
				if self.fuelUsageUpdate >= self.updateFuelUsageInterval then
					self.fuelUsageUpdate = 0
					self.fuelUsage = self.vehicle.spec_motorized.lastFuelUsage
					self.updateFuelUsageInterval = 500
				end
			end
			if (self.hasDiesel or self.hasElectric or self.hasMethane) and (motorState == MotorState.ON or motorState == MotorState.STARTING) then
				self.fuelUpdate = self.fuelUpdate + dt
				if self.fuelUpdate >= self.updateFuelInterval then
					self.fuelUpdate = 0
					local specFillUnit = self.vehicle.spec_fillUnit
					for _, fillUnit in ipairs(specFillUnit.fillUnits) do
						self.fuelLevels[fillUnit.fillType] = fillUnit.fillLevel
					end
					self.updateFuelInterval = 500
				end
			end
		end
	end
end
function RoadMasterHUD:draw()
	local vehicle = self.vehicle
	if vehicle == nil or not self.isVehicleDrawSafe or vehicle.spec_roadMaster == nil then
		return
	end
	local rm_speedBgX, rm_speedBgY = g_currentMission.hud.speedMeter.speedBg:getPosition()
	local rm_posX = rm_speedBgX + g_currentMission.hud.speedMeter.speedGaugeCenterOffsetX
	local rm_posY = rm_speedBgY + g_currentMission.hud.speedMeter.speedGaugeCenterOffsetY
	local motorState = vehicle:getMotorState()
	if vehicle.spec_roadMaster.showOdometer then
		local unit = g_i18n:getMeasuringUnit()
		local textBG, text, otextBG, otext
		local odometerTextPosX = rm_posX - self.rm_odometerTextOffsetX
		local odometerTextPosY = rm_posY + self.rm_odometerTextOffsetY
		local odometerUnitPosX = odometerTextPosX - self.rm_UnitOffsetX
		local odometerUnitPosY = odometerTextPosY
		local drivenDistance = vehicle:getOdometer()
		local distanceInKM = drivenDistance / 1000
		distanceInKM = distanceInKM % 999999
		local distance = g_i18n:getDistance(distanceInKM, true)
		if vehicle.spec_roadMaster.displayMode == 1 then
			local odoKm = math.floor(distance)
			textBG = string.format("%08d", odoKm)
			text   = string.format("%d", odoKm)
		else
			local drivenDistance = vehicle:getTrip()
			local distanceInKM = drivenDistance / 1000
			distanceInKM = distanceInKM % 999.9
			local distance = g_i18n:getDistance(distanceInKM, true)
			distance = math.floor(distance * 10) / 10
			textBG = string.format("%05.1f", distance)
			text = string.format("%.1f", distance)
			odometerTextPosX = rm_posX - self.rm_tripTextOffsetX
			odometerTextPosY = rm_posY + self.rm_tripTextOffsetY
			odometerUnitPosX = odometerTextPosX - self.rm_UnitOffsetX
			odometerUnitPosY = odometerTextPosY
			local tripPosX = rm_posX + self.rm_tripOffsetX
			local tripPosY = rm_posY + self.rm_tripOffsetY
			setTextAlignment(RenderText.ALIGN_RIGHT)
			setTextColor(1,1,1,1)
			renderText(tripPosX, tripPosY, self.rm_tripSize, "trip")
		end
		otextBG = string.format("%08d", distance)
		otext   = string.format("%d", distance)
		if vehicle.spec_roadMaster.displayOdo == 3 then	
			self.odometerBg:setColor(unpack({0, 0, 0, 0.65}))
			self.odometerBg:setPosition(rm_speedBgX - self.odometerOffsetX, rm_speedBgY - self.odometerOffsetY)
			self.odometerBg:render()
		end
		local textColor = RoadMasterHUD.COLOR.TEXT
		local textColorBG = RoadMasterHUD.COLOR.TEXT_BACKGROUND
		if vehicle.spec_motorized ~= nil then
			setTextBold(false)
			setTextAlignment(RenderText.ALIGN_RIGHT)
			setTextColor(unpack(HUD.COLOR.ACTIVE))
			renderText(odometerUnitPosX, odometerUnitPosY, self.rm_odometerTextSize, unit)
			setTextBold(false)
			setTextAlignment(RenderText.ALIGN_RIGHT)
			setTextColor(textColorBG[1], textColorBG[2], textColorBG[3], textColorBG[4])
			renderText(odometerTextPosX, odometerTextPosY, self.rm_odometerTextSize, textBG)
			setTextColor(textColor[1], textColor[2], textColor[3], textColor[4])
			renderText(odometerTextPosX, odometerTextPosY, self.rm_odometerTextSize, text)
			if vehicle.spec_roadMaster.displayOdo == 3 then
				local odometerBgX, odometerBgY = self.odometerBg:getPosition()
				local odometerTextPosX = odometerBgX - self.rm_odometerBgTextOffsetX
				local odometerTextPosY = odometerBgY + self.rm_odometerBgTextOffsetY
				local odometerUnitPosX = odometerTextPosX - self.rm_UnitOffsetX
				local odometerUnitPosY = odometerTextPosY
				setTextBold(false)
				setTextAlignment(RenderText.ALIGN_RIGHT)
				setTextColor(unpack(HUD.COLOR.ACTIVE))
				renderText(odometerUnitPosX, odometerUnitPosY, self.rm_odometerTextSize, unit)
				setTextBold(false)
				setTextAlignment(RenderText.ALIGN_RIGHT)
				setTextColor(textColorBG[1], textColorBG[2], textColorBG[3], textColorBG[4])
				renderText(odometerTextPosX, odometerTextPosY, self.rm_odometerTextSize, otextBG)
				setTextColor(textColor[1], textColor[2], textColor[3], textColor[4])
				renderText(odometerTextPosX, odometerTextPosY, self.rm_odometerTextSize, otext)
			end
			if vehicle.spec_roadMaster.displayOdo == 2 then
				g_currentMission.hud.speedMeter.speedTextSize = self:scalePixelToScreenHeight(45)
				local odometerTextPosX = rm_posX - self.odometerTextOffsetX
				local odometerTextPosY = rm_posY + self.odometerTextOffsetY
				local odometerUnitPosX = odometerTextPosX - self.rm_UnitOffsetX
				local odometerUnitPosY = odometerTextPosY 
				setTextBold(false)
				setTextAlignment(RenderText.ALIGN_RIGHT)
				setTextColor(unpack(HUD.COLOR.ACTIVE))
				renderText(odometerUnitPosX, odometerUnitPosY, self.rm_odometerTextSize, unit)
				setTextBold(false)
				setTextAlignment(RenderText.ALIGN_RIGHT)
				setTextColor(textColorBG[1], textColorBG[2], textColorBG[3], textColorBG[4])
				renderText(odometerTextPosX, odometerTextPosY, self.rm_odometerTextSize, otextBG)
				setTextColor(textColor[1], textColor[2], textColor[3], textColor[4])
				renderText(odometerTextPosX, odometerTextPosY, self.rm_odometerTextSize, otext)
				local v140 = HUD.COLOR.ACTIVE
				local v141 = rm_posX + self.odoSeperatorOffsetX
				local v142 = rm_posY + self.odoSeperatorOffsetY
				local v143 = v141 + self.odoSeperatorWidth
				drawLine2D(v141, v142, v143, v142, g_pixelSizeY, v140[1], v140[2], v140[3], v140[4])
			end
		end
	end
	if vehicle.spec_roadMaster.showTemp and (self.hasDiesel or self.hasMethane) then
		if vehicle.spec_motorized ~= nil then
			local _useF = g_gameSettings:getValue(GameSettings.SETTING.USE_FAHRENHEIT)
			local _s = "C"
			if _useF then _s = "F" end
			local temp_txt1 = "0"
			local temp_txt2 = "\n°" .. _s
			if motorState == MotorState.ON or motorState == MotorState.IGNITION or motorState == MotorState.STARTING then
				local _value = vehicle.spec_motorized.motorTemperature.value
				if _useF then _value = _value * 1.8 + 32 end
				temp_txt1 = string.format("%i", _value)
			end
			local tempTextOffsetX = rm_posX + self.rm_tempTextOffsetX 
			local tempTextOffsetY = rm_posY + self.rm_tempTextOffsetY
			setTextColor(1,1,1,1)
			setTextAlignment(RenderText.ALIGN_CENTER)
			setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
			setTextBold(true)
			renderText(tempTextOffsetX, tempTextOffsetY, self.rm_tempTextSize, temp_txt1)
			setTextColor(unpack(HUD.COLOR.ACTIVE))
			renderText(tempTextOffsetX, tempTextOffsetY, self.rm_tempTextSize, temp_txt2)
		end
	end
	if vehicle.spec_roadMaster.showRpm and (self.hasDiesel or self.hasMethane) then
		if vehicle.spec_motorized ~= nil then
			local rpm_txt1 = "0"
			local rpm_txt2 = "\nrpm"
			if motorState == MotorState.ON or motorState == MotorState.STARTING then
				rpm_txt1 = string.format("%i", vehicle.spec_motorized:getMotorRpmReal())
			end
			local rpmTextOffsetX = rm_posX + self.rm_rpmTextOffsetX 
			local rpmTextOffsetY = rm_posY + self.rm_rpmTextOffsetY
			setTextColor(1,1,1,1)
			setTextAlignment(RenderText.ALIGN_CENTER)
			setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
			setTextBold(true)
			renderText(rpmTextOffsetX, rpmTextOffsetY, self.rm_rpmTextSize, rpm_txt1)
			setTextColor(unpack(HUD.COLOR.ACTIVE))
			renderText(rpmTextOffsetX, rpmTextOffsetY + 0.002, self.rm_rpmTextSize, rpm_txt2)
		end
	end
	if vehicle.spec_roadMaster.showFuelUsage and (self.hasDiesel or self.hasElectric or self.hasMethane) then
		if (motorState == MotorState.ON or motorState == MotorState.STARTING) and vehicle.spec_fillUnit ~= nil then
			local electric  = self.fuelLevels and self.fuelLevels[FillType.ELECTRICCHARGE]
			if electric ~= nil and electric >= 0 then
				if self.lastfuelUsageText1 ~= "kW" then
					self.lastfuelUsageText1 = "kW"
				end
			else
				if self.lastfuelUsageText1 ~= "l/h" then
					self.lastfuelUsageText1 = "l/h"
				end
			end
			local currentFuelUsage = string.format("%.1f", self.fuelUsage)
			if self.lastfuelUsageText2 ~= currentFuelUsage then
				self.lastfuelUsageText2 = currentFuelUsage
			end
			local fuelIconX, fuelIconY = g_currentMission.hud.speedMeter.fuelIcon:getPosition()
			local fuelTextOffsetX = fuelIconX + self.rm_fuelTextOffsetX - 0.001
			local fuelTextOffsetX_ = fuelIconX + self.rm_fuelTextOffsetX + 0.001
			local fuelTextOffsetY = fuelIconY + self.rm_fuelTextOffsetY
			setTextAlignment(RenderText.ALIGN_LEFT)
			setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
			setTextBold(true)
			setTextColor(unpack(HUD.COLOR.ACTIVE))
			renderText(fuelTextOffsetX_, fuelTextOffsetY, self.rm_fuelTextSize, self.lastfuelUsageText1)
			setTextAlignment(RenderText.ALIGN_RIGHT)
			setTextColor(1,1,1,1)
			renderText(fuelTextOffsetX, fuelTextOffsetY, self.rm_fuelTextSize, self.lastfuelUsageText2)
		end
	end
	if vehicle.spec_roadMaster.showFuel and (self.hasDiesel or self.hasElectric or self.hasMethane) then
		if (motorState == MotorState.ON or motorState == MotorState.IGNITION or motorState == MotorState.STARTING) and vehicle.spec_fillUnit ~= nil then
			self.fuelBg:setColor(unpack({0, 0, 0, 0.65}))
			self.fuelBg:setPosition(rm_speedBgX - self.fuelBgOffsetX, rm_speedBgY - self.fuelBgOffsetY)
			self.fuelBg:render()
			local fuelTypes = {
				{value = self.fuelLevels and self.fuelLevels[FillType.ELECTRICCHARGE], unit = "kWh"},
				{value = self.fuelLevels and self.fuelLevels[FillType.DIESEL], unit = "l"},
				{value = self.fuelLevels and self.fuelLevels[FillType.DEF], unit = "l"},
				{value = self.fuelLevels and self.fuelLevels[FillType.METHANE], unit = "l"}
			}
			local currentFuel = nil
			for _, fuel in ipairs(fuelTypes) do
				if fuel.value ~= nil and fuel.value >= 0 then
					currentFuel = string.format("%.1f %s", fuel.value, fuel.unit)
					break
				end
			end
			if currentFuel == nil then
				currentFuel = string.format("%.1f l", 0)
			end
			if self.lastFuelText ~= currentFuel then
				self.lastFuelText = currentFuel
			end
			local fuelBgX, fuelBgY = self.fuelBg:getPosition()
			local fuelBgWidth, fuelBgHeight = self:scalePixelValuesToScreenVector(96, 20)
			local fuelTextPosX = fuelBgX + (fuelBgWidth / 2)
			local fuelTextPosY = fuelBgY + (fuelBgHeight / 2) + (self.rm_fuelTextSize / 1.6)
			setTextBold(false)
			setTextAlignment(RenderText.ALIGN_CENTER)
			setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
			setTextColor(1,1,1,1)
			renderText(fuelTextPosX, fuelTextPosY, self.rm_fuelTextSize, self.lastFuelText)
		end
	end
	local gearIconX, gearIconY = g_currentMission.hud.speedMeter.gearIcon:getPosition()
	local aiWorkerIconX, aiWorkerIconY = g_currentMission.hud.speedMeter.aiWorkerIcon:getPosition()
	--if vehicle.typeName == 'combineDrivable' then
	local specCombine = vehicle.spec_combine
	if specCombine ~= nil and specCombine.chopper.isAvailable and vehicle.typeName ~= 'riceHarvester' then
		self.StrawSwathLamp:setVisible(true)
		if vehicle:getAnimationTime(specCombine.chopper.animName) == 0 then
			self.StrawSwathLamp:setColor(unpack(HUD.COLOR.ACTIVE))
		elseif vehicle:getAnimationTime(specCombine.chopper.animName) == 1 then
			self.StrawSwathLamp:setColor(unpack(RoadMasterHUD.COLOR.TEXT_BACKGROUND))
		end
		self.StrawSwathLamp:setPosition(gearIconX + self.hSSLampOffsetX, gearIconY + self.hSSLampOffsetY)
		self.StrawSwathLamp:render()
	end
	local specPipe = vehicle.spec_pipe
	if specPipe ~= nil and specPipe.hasMovablePipe then
		if vehicle.getCurrentPipeState ~= nil then
			self.pipe:setVisible(true)
			if vehicle:getCurrentPipeState() == 1 then
				self.pipe:setColor(unpack(RoadMasterHUD.COLOR.TEXT_BACKGROUND))
			elseif vehicle:getCurrentPipeState() == 2 then
				self.pipe:setColor(unpack(HUD.COLOR.ACTIVE))
			end
			self.pipe:setPosition(gearIconX + self.pipeOffsetX, gearIconY + self.pipeOffsetY)
			self.pipe:render()
		end
	end
	--end
	setTextColor(1,1,1,1)
	setTextAlignment(RenderText.ALIGN_LEFT)
	setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_BASELINE)
	setTextBold(false)
end