
RoadMasterSettings = {}
local RoadMasterSettings_mt = Class(RoadMasterSettings, ScreenElement)
function RoadMasterSettings.register()
	local self = RoadMasterSettings.new()
	g_gui:loadGui(g_roadMasterDirectory .. "gui/dialogs/RoadMasterSettings.xml", "RoadMasterSettings", self)
	RoadMasterSettings.INSTANCE = self
end
function RoadMasterSettings.show(vehicle)
	if RoadMasterSettings.INSTANCE ~= nil then
		local self = RoadMasterSettings.INSTANCE
		self.vehicle = vehicle
		g_gui:showDialog("RoadMasterSettings")
	end
end
function RoadMasterSettings.new(target, custom_mt)
	local self = DialogElement.new(target, custom_mt or RoadMasterSettings_mt)
	self.vehicle = nil
	self.i18n = g_i18n.modEnvironments[g_roadMasterModName]
	return self
end
function RoadMasterSettings:delete()
end
function RoadMasterSettings:setVehicle(vehicle)
	self.vehicle = vehicle
end
function RoadMasterSettings:onOpen()
	RoadMasterSettings:superClass().onOpen(self)
	g_messageCenter:subscribe(MessageType.RM_SETSAVE, self.onRMSaetSaveEvent, self)
	local v59 = true
	for _, element in pairs(self.settingsboxLayout.elements) do
		if element.name == "sectionHeader" then
			v59 = true
		elseif element:getIsVisible() then
			local colorcode = RoadMasterSettings.COLOR_ALTERNATING[v59]
			element:setImageColor(nil, unpack(colorcode))
			v59 = not v59
		end
	end
	local displayModeTable = {}
	table.insert(displayModeTable, self.i18n:getText("RM_setting_displayModeOption1"))
	table.insert(displayModeTable, self.i18n:getText("RM_setting_displayModeOption2"))
	self.multidisplayMode:setTexts(displayModeTable)
	local displayOdoTable = {}
	table.insert(displayOdoTable, self.i18n:getText("RM_setting_displayOdoOption1"))
	table.insert(displayOdoTable, self.i18n:getText("RM_setting_displayOdoOption2"))
	table.insert(displayOdoTable, self.i18n:getText("RM_setting_displayOdoOption3"))
	self.multidisplayOdo:setTexts(displayOdoTable)
	local fuelDiesel_current = -1
	local fuelElectric_current = -1
	local fuelAdblue_current = -1
	local fuelMethane_current = -1
	local specfillUnit = self.vehicle.spec_fillUnit
	for _, fillUnit in ipairs(specfillUnit.fillUnits) do
		if fillUnit.fillType == FillType.DIESEL then
			fuelDiesel_max = fillUnit.capacity
			fuelDiesel_current = fillUnit.fillLevel
		end
		if fillUnit.fillType == FillType.DEF then
			fuelAdblue_max = fillUnit.capacity
			fuelAdblue_current = fillUnit.fillLevel
		end
		if fillUnit.fillType == FillType.ELECTRICCHARGE then
			fuelElectric_max = fillUnit.capacity
			fuelElectric_current = fillUnit.fillLevel
		end
		if fillUnit.fillType == FillType.METHANE then
			fuelMethane_max = fillUnit.capacity
			fuelMethane_current = fillUnit.fillLevel
		end
	end
	local distanceunitText = g_i18n:getMeasuringUnit(false)
	local speedunitText = g_i18n:getSpeedMeasuringUnit()
	local remainingOperatingtime = 0
	local remainingOperatingtimeString = "-/-"
	local fuelText = "-/-"
	local averageSpeedString = "-/- "..speedunitText
	local distanceString = "-/- "..distanceunitText
	local motorState = self.vehicle:getMotorState()
	if motorState == MotorState.ON then
		if fuelElectric_current >= 0 then
			remainingOperatingtime = fuelElectric_current / self.vehicle.spec_motorized.lastFuelUsage
		elseif fuelDiesel_current >= 0 then
			if self.vehicle.spec_motorized.lastFuelUsage > 0 then
				remainingOperatingtime = fuelDiesel_current / self.vehicle.spec_motorized.lastFuelUsage
				remainingOperatingtimeString = string.format("%.2f"..g_i18n:getText("RM_setting_hours"), remainingOperatingtime)
				fuelText = string.format("%.1f / %.1f L", fuelDiesel_current, fuelDiesel_max)
			end
		elseif fuelMethane_current >= 0 then
			if self.vehicle.spec_motorized.lastFuelUsage > 0 then
				remainingOperatingtime = fuelMethane_current / self.vehicle.spec_motorized.lastFuelUsage
				remainingOperatingtimeString = string.format("%.2f"..g_i18n:getText("RM_setting_hours"), remainingOperatingtime)
				fuelText = string.format("%.1f / %.1f L", fuelMethane_current, fuelMethane_max)
			end
		end
		averageSpeedString = string.format("%.0f "..speedunitText, g_i18n:getSpeed(self.vehicle:getAverageSpeed()))
		local distance = remainingOperatingtime * self.vehicle:getAverageSpeed()
		distanceString = string.format("%.1f "..distanceunitText, g_i18n:getSpeed(distance))
	end
	self.remainingOpTime:setText(remainingOperatingtimeString)
	self.averageSpeedText:setText(averageSpeedString)
	self.distanceText:setText(distanceString)
	self.fuelLevel:setText(fuelText)
	self:updateValues()
end
function RoadMasterSettings:updateValues()
	self.checkshowOdometer:setIsChecked(self.vehicle:getshowOdometer())
	self.checkshowFuelUsage:setIsChecked(self.vehicle:getshowFuelUsage())
	self.checkshowFuel:setIsChecked(self.vehicle:getshowFuel())
	self.checkshowTemp:setIsChecked(self.vehicle:getshowTemp())
	self.checkshowRpm:setIsChecked(self.vehicle:getshowRpm())
	self.multidisplayMode:setState(self.vehicle:getdisplayMode())
	self.multidisplayOdo:setState(self.vehicle:getdisplayOdo())
	self.checkgameOpHours:setIsChecked(self.vehicle:getgameOpHours())
end
function RoadMasterSettings:onClickOk()
	if self.vehicle == nil then return end
	local Odometer = self.checkshowOdometer:getIsChecked()
	local Mode = self.multidisplayMode:getState()
	local Odo = self.multidisplayOdo:getState()
	local FuelUsage = self.checkshowFuelUsage:getIsChecked()
	local Fuel = self.checkshowFuel:getIsChecked()
	local Temp = self.checkshowTemp:getIsChecked()
	local Rpm = self.checkshowRpm:getIsChecked()
	local OpHours = self.checkgameOpHours:getIsChecked()
	g_client:getServerConnection():sendEvent(RMVehicle_Event.new(self.vehicle, Odometer, Mode, Odo, FuelUsage, Fuel, Temp, Rpm, OpHours, false))
	g_gui:closeDialogByName("RoadMasterSettings")
end
function RoadMasterSettings:onClickOkGlobal()
	if self.vehicle == nil then return end
	local Odometer = self.checkshowOdometer:getIsChecked()
	local Mode = self.multidisplayMode:getState()
	local Odo = self.multidisplayOdo:getState()
	local FuelUsage = self.checkshowFuelUsage:getIsChecked()
	local Fuel = self.checkshowFuel:getIsChecked()
	local Temp = self.checkshowTemp:getIsChecked()
	local Rpm = self.checkshowRpm:getIsChecked()
	local OpHours = self.checkgameOpHours:getIsChecked()
	g_client:getServerConnection():sendEvent(RMVehicle_Event.new(self.vehicle, Odometer, Mode, Odo, FuelUsage, Fuel, Temp, Rpm, OpHours, true))
	g_gui:closeDialogByName("RoadMasterSettings")
end
function RoadMasterSettings.onRMSaetSaveEvent(self, vehicle, _)
	if vehicle == self.vehicle then
		--self:setVehicle(vehicle)
		--self.vehicle:setRoadMaster(vehicle, odometer, mode, fuelusage, temp, rpm, ophours)
		--self:updateValues()
	end
end
function RoadMasterSettings:onClickBack()
	g_gui:closeDialogByName("RoadMasterSettings")
end
RoadMasterSettings.COLOR_ALTERNATING = {
	[true] = {
		0.02956,
		0.02956,
		0.02956,
		0.6
	},
	[false] = {
		0.02956,
		0.02956,
		0.02956,
		0.2
	}
}