
RoadMasterMain = {}
local RoadMasterMain_mt = Class(RoadMasterMain)
function RoadMasterMain:new(modDirectory, modName)
	local self = {}
	setmetatable(self, RoadMasterMain_mt)
	self.modDirectory = modDirectory
	self.modName = modName
	return self
end
function RoadMasterMain:onMissionLoaded(mission)
	self.mission = mission
	RoadMasterMain.rmHud = RoadMasterHUD.new()
	RoadMasterMain.rmHud:setScale(g_gameSettings:getValue(GameSettings.SETTING.UI_SCALE))
	RoadMasterMain.rmHud:setVehicle(nil)
	table.insert(mission.hud.displayComponents, RoadMasterMain.rmHud)	
	mission.hud.setControlledVehicle = Utils.appendedFunction(mission.hud.setControlledVehicle, function(self, vehicle)
		RoadMasterMain.rmHud:setVehicle(vehicle)
		RoadMasterMain.rmHud:setVisible(vehicle ~= nil and vehicle.spec_motorized ~= nil, true)
	end)
	mission.hud.update = Utils.appendedFunction(mission.hud.update, function(self, dt)
		RoadMasterMain.rmHud:update(dt)
	end)
	mission.hud.drawControlledEntityHUD = Utils.appendedFunction(mission.hud.drawControlledEntityHUD, function(self)
		if self.isVisible then
			RoadMasterMain.rmHud:draw()
		end
	end)
	RoadMasterSettings.register()
end
function RoadMasterMain.installSpecializations(vehicleTypeManager, specializationManager, modDirectory, modName)
	specializationManager:addSpecialization("roadMaster", "RoadMaster", Utils.getFilename("scripts/vehicles/specializations/RoadMaster.lua", modDirectory), nil)
	if specializationManager:getSpecializationByName("roadMaster") == nil then
		Logging.error("[RM] getSpecializationByName(\"roadMaster\") == nil")
	else
		for vehicleName, vehicleType in pairs(vehicleTypeManager.types) do
			if vehicleType ~= nil and vehicleName ~= "locomotive" and vehicleName ~= "trainTrailer" and vehicleName ~= "trainTimberTrailer" and vehicleName ~= "conveyorBelt"
			and vehicleName ~= "pickupConveyorBelt" 
			then
				if SpecializationUtil.hasSpecialization(Drivable, vehicleType.specializations) and
					SpecializationUtil.hasSpecialization(Enterable, vehicleType.specializations) and
					SpecializationUtil.hasSpecialization(Motorized, vehicleType.specializations) then
						vehicleTypeManager:addSpecialization(vehicleName, modName .. ".roadMaster")
						print("  Register RoadMaster '" .. vehicleName.."'")
				end
			else
				Logging.info("  No register RoadMaster '" .. vehicleName.."'")
			end
		end
	end
end
function RoadMasterMain:delete()
	RoadMasterSettings.INSTANCE:delete()
end