
local directory = g_currentModDirectory
local modName = g_currentModName
g_roadMasterModName = modName
g_roadMasterDirectory = directory
source(Utils.getFilename("scripts/RoadMasterMain.lua", directory))
source(Utils.getFilename("scripts/gui/hud/RoadMasterHUD.lua", directory))
source(Utils.getFilename("scripts/gui/RoadMasterSettings.lua", directory))
source(Utils.getFilename("scripts/vehicles/specializations/events/RMVehicle_Event.lua", directory))
local roadMaster
local function isEnabled()
	return roadMaster ~= nil
end
function init()
	roadMaster = RoadMasterMain:new(directory, modName)
	FSBaseMission.delete = Utils.appendedFunction(FSBaseMission.delete, unload)
	Mission00.load = Utils.prependedFunction(Mission00.load, loadMission)
	Mission00.loadMission00Finished = Utils.appendedFunction(Mission00.loadMission00Finished, loadedMission)
	TypeManager.validateTypes = Utils.prependedFunction(TypeManager.validateTypes, validateVehicleTypes)
	MessageType.RM_SETSAVE = nextMessageTypeId()
end
function loadMission(mission)
	mission.roadMaster = roadMaster
	addModEventListener(roadMaster)
end
function loadedMission(mission, node)
	if not isEnabled() then
		print("Error: roadMaster is nil, not enabled")
		return
	end
	if mission.cancelLoading then
		return
	end
	roadMaster:onMissionLoaded(mission)
end
function roadMastersaveToXMLFile(missionInfo)
	if isEnabled() and missionInfo.isValid then
		local savegameFolderPath = missionInfo.savegameDirectory 
		if savegameFolderPath == nil then
			savegameFolderPath = ('%ssavegame%d'):format(getUserProfileAppPath(), missionInfo.savegameIndex)
		end
	end
end
function validateVehicleTypes(typeManager)
	if typeManager.typeName == "vehicle" then
		RoadMasterMain.installSpecializations(g_vehicleTypeManager, g_specializationManager, directory, modName)
	end
end
function unload()
	if not isEnabled() then
		return
	end
	removeModEventListener(roadMaster)
	roadMaster:delete()
	roadMaster = nil
	if g_currentMission ~= nil then
		g_currentMission.roadMaster = nil
	end
end
init()