function FillTriggerVehicle:PostLoadExtended(...)
    if self.typeName == "waterTrailer" or self.typeName == "fuelTrailer" or self.typeName == "trailer" then
        for i, fillUnit in ipairs(self.spec_fillUnit.fillUnits) do
            fillUnit.supportedFillTypes = FillUnit:InsertLiquids(fillUnit.supportedFillTypes)
            --for supportedFillType, _ in pairs(fillUnit.supportedFillTypes) do
            --print(g_fillTypeManager:getFillTypeNameByIndex(supportedFillType))
            --end
        end
    end
end

function FillUnit:InsertLiquids(supportedFillTypes)
    local LiquidFilltypes = {
        FillType.WATER,
        FillType.MILK,
        FillType.LIQUIDFERTILIZER,
        FillType.HERBICIDE,
        FillType.DIESEL
    }

    local function isLiquid(fillType)
        for _, liquidType in ipairs(LiquidFilltypes) do
            if liquidType == fillType then
                return true
            end
        end
        return false
    end

    for supportedFillType, _ in pairs(supportedFillTypes) do
        if not isLiquid(supportedFillType) then
            return supportedFillTypes
        end
    end

    for _, liquidType in ipairs(LiquidFilltypes) do
        if supportedFillTypes[liquidType] == nil then
            supportedFillTypes[liquidType] = true
        end
    end

    return supportedFillTypes
end

FillTriggerVehicle.onLoad = Utils.appendedFunction(FillTriggerVehicle.onLoad, FillTriggerVehicle.PostLoadExtended)