-- Author:Benji
-- Name:FH_MPAddon.lua
-- Namespace: local
-- Description:
-- Icon:
-- Hide: no
-- AlwaysLoaded: no

-- ========================================
-- FS25 ForestryHelper MP Addon
-- Unlock tree cutting on all farmland
-- ========================================

	FH_MPAddon = {}


	Mission00.loadMission00Finished = Utils.appendedFunction(
    Mission00.loadMission00Finished,
    function(mission)

        -- ----------------------------------------
        -- OVERRIDE FARMLAND ACCESS (CRITICAL)
        -- ----------------------------------------
        if g_currentMission.accessHandler ~= nil then

            local originalCanFarmAccessLand = g_currentMission.accessHandler.canFarmAccessLand

            g_currentMission.accessHandler.canFarmAccessLand = function(accessHandler, x, z, farmId)
                -- Allow chainsaw cutting everywhere
                return true
            end

            print("[FH_MPAddon] Farmland access overridden (cutting allowed everywhere)")
        end
		
        -- ----------------------------------------
        -- Chainsaw ring selector (visual + client)
        -- ----------------------------------------
        HandToolChainsaw.updateRingSelector = Utils.overwrittenFunction(
            HandToolChainsaw.updateRingSelector,
            function(chainsaw, superFunc, shape, canBeCut, minY, maxY, minZ, maxZ)

                if shape ~= nil and shape ~= 0 then
                    canBeCut = true
                end

                return superFunc(chainsaw, shape, canBeCut, minY, maxY, minZ, maxZ)
            end
        )

        -- ----------------------------------------
        -- Safety for custom maps
        -- ----------------------------------------
        if ChainsawUtil.getCanBeCut ~= nil then
            ChainsawUtil.getCanBeCut = function(...)
                return true
            end
        end
    end
)
