--[[
Copyright (C) GtX (Andy), 2025

Author: GtX | Andy
Date: 27.04.2025
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

PlaceableSetIsReconfiguratingEvent = {}

local PlaceableSetIsReconfiguratingEvent_mt = Class(PlaceableSetIsReconfiguratingEvent, Event)
InitEventClass(PlaceableSetIsReconfiguratingEvent, "PlaceableSetIsReconfiguratingEvent")

function PlaceableSetIsReconfiguratingEvent.emptyNew()
    return Event.new(PlaceableSetIsReconfiguratingEvent_mt, NetworkNode.CHANNEL_MAIN)
end

function PlaceableSetIsReconfiguratingEvent.new(object)
    local self = PlaceableSetIsReconfiguratingEvent.emptyNew()

    self.object = object

    return self
end

function PlaceableSetIsReconfiguratingEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)

    if self.object ~= nil and self.object:getIsSynchronized() then
        self.object.isReloading = true
        self.object.isReconfigurating = true
    end
end

function PlaceableSetIsReconfiguratingEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)
end
