--[[
Copyright (C) GtX (Andy), 2025

Author: GtX | Andy
Date: 27.04.2025
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

ChangePlaceableConfigEvent = {}

local ChangePlaceableConfigEvent_mt = Class(ChangePlaceableConfigEvent, Event)
InitEventClass(ChangePlaceableConfigEvent, "ChangePlaceableConfigEvent")

function ChangePlaceableConfigEvent.emptyNew()
    return Event.new(ChangePlaceableConfigEvent_mt, NetworkNode.CHANNEL_MAIN)
end

function ChangePlaceableConfigEvent.new(placeable, placeableBuyData)
    local self = ChangePlaceableConfigEvent.emptyNew()

    self.placeable = placeable
    self.placeableBuyData = placeableBuyData

    return self
end

function ChangePlaceableConfigEvent.newServerToClient(success)
    local self = ChangePlaceableConfigEvent.emptyNew()

    self.success = success

    return self
end

function ChangePlaceableConfigEvent:readStream(streamId, connection)
    if connection:getIsServer() then
        self.success = streamReadBool(streamId)
    else
        self.placeable = NetworkUtil.readNodeObject(streamId)

        self.placeableBuyData = BuyPlaceableData.new()
        self.placeableBuyData:readStream(streamId, connection)
        self.placeableBuyData:updatePrice()
    end

    self:run(connection)
end

function ChangePlaceableConfigEvent:writeStream(streamId, connection)
    if connection:getIsServer() then
        NetworkUtil.writeNodeObject(streamId, self.placeable)

        self.placeableBuyData:writeStream(streamId, connection)
    else
        streamWriteBool(streamId, self.success)
    end
end

function ChangePlaceableConfigEvent:run(connection)
    if not connection:getIsServer() then
        local existingPlaceable = self.placeable

        -- Can the placeable be configured and does the player have permission to do so?
        if existingPlaceable:getNeedsSaving() and not existingPlaceable.isPreplaced and not g_currentMission:getHasPlayerPermission("buyPlaceable", connection) then
            connection:sendEvent(ChangePlaceableConfigEvent.newServerToClient(false))

            return
        end

        local placeableSystem = g_currentMission.placeableSystem
        local placeableBuyData = self.placeableBuyData

        local valid = false
        local price = placeableBuyData.price or 0
        local existingPrice = existingPlaceable.price or g_currentMission.economyManager:getBuyPrice(existingPlaceable.storeItem, existingPlaceable.configurations) or 0

        local xmlFile = XMLFile.create("placeableXMLFile", "", "placeables", Placeable.xmlSchemaSavegame)

        xmlFile:setValue("placeables#version", placeableSystem.version)

        for i, placeable in ipairs(placeableSystem.placeables) do
            if existingPlaceable == placeable then
                existingPlaceable:setConfigurations(placeableBuyData.configurations, placeableBuyData.boughtConfigurations, placeableBuyData.configurationData)
                existingPlaceable.price = price -- Change the price before saving so it is updated on load

                placeableSystem:savePlaceableToXML(existingPlaceable, xmlFile, 0, i, {})
                valid = xmlFile:getNumOfElements("placeables.placeable") > 0

                break
            end
        end

        if not valid then
            connection:sendEvent(ChangePlaceableConfigEvent.newServerToClient(false))

            return
        end

        local function asyncCallbackFunction(_, loadedPlaceables, placeableLoadingState, args)
            local placeable = loadedPlaceables[1]
            local success = placeable ~= nil

            if success then
                local upgradePrice = 0

                if existingPrice < price then
                    upgradePrice = price - existingPrice
                end

                if upgradePrice > 0 then
                    g_currentMission:addMoney(-math.abs(upgradePrice), placeableBuyData.ownerFarmId, MoneyType.SHOP_PROPERTY_BUY, true, true)
                end

                existingPlaceable.isReloading = true -- Used by some specialisations
                existingPlaceable.isReconfigurating = true -- Flag raised on vehicles, possible future use
                g_server:broadcastEvent(PlaceableSetIsReconfiguratingEvent.new(existingPlaceable), nil, nil, existingPlaceable)

                existingPlaceable:removeFromPhysics()
                existingPlaceable:delete(true)
            else
                existingPlaceable.price = existingPrice
                existingPlaceable:addToPhysics()

                placeableSystem:addPlaceable(existingPlaceable) -- Config failed so restore this placeable
            end

            xmlFile:delete()
            connection:sendEvent(ChangePlaceableConfigEvent.newServerToClient(success))
        end

        g_asyncTaskManager:addTask(function()
            placeableSystem:removePlaceable(existingPlaceable) -- Free up the unique id
            placeableSystem:loadFromXMLFile(xmlFile, asyncCallbackFunction, nil, {})
        end)
    else
        if g_constructionScreenExtension ~= nil then
            g_constructionScreenExtension:onPlaceableChanged(self.success)
        end
    end
end
