--[[
Copyright (C) GtX (Andy), 2025

Author: GtX | Andy
Date: 27.04.2025
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

ConstructionBrushCustomField = {}
ConstructionBrushCustomField.MOD_NAME = g_currentModName
ConstructionBrushCustomField.MOD_DIRECTORY = g_currentModDirectory

-- Backup values
ConstructionBrushCustomField.FIELD_PRICE_PER_SQM = 0.01
ConstructionBrushCustomField.GROUND_PRICE_PER_SQM = 0.01
ConstructionBrushCustomField.FRUIT_PRICE_PER_SQM = 0.01

local ConstructionBrushCustomField_mt = Class(ConstructionBrushCustomField, ConstructionBrushRiceField)

function ConstructionBrushCustomField.new(customMt, cursor)
    local self = ConstructionBrushCustomField:superClass().new(customMt or ConstructionBrushCustomField_mt, cursor)

    self.overlapCollisionMask = CollisionFlag.WATER + CollisionFlag.PLACEMENT_BLOCKING

    self.requiredPermission = Farm.PERMISSION.BUY_PLACEABLE
    self.supportsPrimaryAxis = false -- Disable Height adjustment

    self.isColorBlindMode = g_gameSettings:getValue(GameSettings.SETTING.USE_COLORBLIND_MODE) == true

    local oldVisualizeLine = self.lineVisualization.visualizeLine

    self.lineVisualization.visualizeLine = function(line3D, sx, sy, sz, ex, ey, ez, alignToTerrain, colour)
        oldVisualizeLine(line3D, sx, sy, sz, ex, ey, ez, true, colour) -- Always align to terrain
    end

    return self
end

function ConstructionBrushCustomField:acquirePlaceable()
    if self.xmlFilename == nil then
        -- Should not happen but added to avoid confusion when reading the log, this way it does not look like the rice field superClass.
        Logging.warning("[ConstructionBrushCustomField] Filename has not been set for placeable!")

        return
    end

    ConstructionBrushCustomField:superClass().acquirePlaceable(self)
end

function ConstructionBrushCustomField:findPlaceable()
    -- Seems that the Rice fields share existing placeabes, this is no good here as it is currently a throw away item after construction.
    -- This method avoids a placeable being deleted in MP that another player may be using at the same time if 2 people are drawing fields.
    if self.placeableObjectId ~= nil then
        return NetworkUtil.getObject(self.placeableObjectId)
    end

    return nil
end

function ConstructionBrushCustomField:onPlaceableCreated(errorCode, _, objectId)
    g_messageCenter:unsubscribe(BuyPlaceableEvent, self)

    if errorCode == BuyPlaceableEvent.STATE_SUCCESS then
        self.placeableObjectId = objectId
        self.doFindPlaceable = true -- Trigger the search in the superClass update loop via findPlaceable()

        return
    end

    self.cursor:setErrorMessage("Loading failed")
end

function ConstructionBrushCustomField:releasePlaceable()
    self.doFindPlaceable = false
    self.placeableObjectId = nil

    if self.placeable ~= nil then
        g_client:getServerConnection():sendEvent(PlaceableCustomFieldEvent.new(self.placeable, nil, true))
        self.placeable = nil
    end
end

function ConstructionBrushCustomField:update(dt)
    ConstructionBrushCustomField:superClass().update(self, dt)

    if self.placeable ~= nil and self.placeable.getCustomFieldMasterUserOnly ~= nil and self.placeable:getCustomFieldMasterUserOnly() then
        if not g_currentMission.isMasterUser then
            self.cursor:setErrorMessage(g_i18n:getText("button_adminLogin"))

            return
        end
    end

    if self.isVertexValid then
        self.cursor:setMessage(g_i18n:formatMoney(self:getPrice(), 0, true, true))
    end
end

function ConstructionBrushCustomField:getPrice()
    if self.currentField ~= nil and self.currentField.polygon ~= nil then
        local areaSqm = self.currentField.polygon:getArea() or 0

        if areaSqm > 0 then
            if self.placeable ~= nil and self.placeable.getCustomFieldPricePerSqm then
                return areaSqm * self.placeable:getCustomFieldPricePerSqm()
            end

            return areaSqm * ConstructionBrushCustomField.FIELD_PRICE_PER_SQM
        end
    end

    return 0
end

function ConstructionBrushCustomField:onButtonPrimary(...)
    if self.placeable ~= nil and self.placeable.getCustomFieldMasterUserOnly ~= nil and self.placeable:getCustomFieldMasterUserOnly() then
        if not g_currentMission.isMasterUser then
            return
        end
    end

    ConstructionBrushCustomField:superClass().onButtonPrimary(self, ...)
end

function ConstructionBrushCustomField:onAxisPrimary(inputValue)
    return nil
end

function ConstructionBrushCustomField:getAxisPrimaryText()
    return nil
end
