HiredHelperTool = {};
HiredHelperTool.metadata = {
	interface = "FS25 ...", --convert ls22 to ls 25
	title = "HiredHelper Tool",
	notes = "Neue Helfer im SP/MP/DetiServer mit Realen Namen etc.",
	author = "(by HappyLooser)",	
	version = "1.0.0.0",	
	build = "(#54)",
	datum = "28.12.2014",
	update = "12.11.2024",
	web = "no",
	info = "Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe:"
}
HiredHelperTool.modDir = g_currentModDirectory;	
function HiredHelperTool:loadMap(name)	
	HiredHelperTool.errorTable = false;
	HiredHelperTool.isMpCheck = false;
	if g_currentMission.hiredHelperMapTool ~= nil then HiredHelperTool.errorTable=true;print(tostring(HiredHelperTool.metadata.title).. " Warning: Mod already exists over Map (HiredHelperMapTool). Ignore Mod !");return;end;
	g_currentMission.hiredHelperTool = HiredHelperTool;
	print("---loading ".. tostring(HiredHelperTool.metadata.title).. " ".. tostring(HiredHelperTool.metadata.version).. tostring(HiredHelperTool.metadata.build).. " ".. tostring(HiredHelperTool.metadata.author).. "---")	
	local oldMaxNumHirables = g_currentMission.maxNumHirables;	
	local replaceDefaultNames = true;
	local helperName = {
		"SALLY";
		"SAM";
		"SCHURA";
		"ZENZ";
		"VIVIAN";
		"REINKE";
		"MAREN";
		"NICKI";
		"LU";
		"FIETE";
		--1-10 replace default names A B C D etc.
		"CATO";
		"CURLY"; 
		"FRANA";
		"FRIIS";
		"IKE";
		"JULES";
		"SANJA";
		"MIKA";
		"APKE";
		"JOYCE";
		
		"ELISA";
		"KAYA";
		"IMRE";
		"JACKY";
		"EIKE";
		"NAT";
		"PATTY";
		"TAM";
		"TADE";
		"TEDE"; --default 30, max 50 etc. etc. to Big = Performenc a Server or/and Client collapse
	};
	if g_currentMission ~= nil and HelperManager ~= nil and g_helperManager ~= nil then 
		g_currentMission.maxNumHirables	= #helperName;		
		if replaceDefaultNames then
			local hString = ""; --"HELPER_";		
			local helperTable = {oldName={};name={},title={},xmlFile={},index={}};		
			for a=1, g_helperManager.numHelpers do
				table.insert(helperTable.oldName, hString.. tostring(g_helperManager.indexToHelper[a].name));					
			end;		
			for a=1, g_helperManager.numHelpers do
				table.insert(helperTable.name, tostring(g_helperManager.indexToHelper[a].name));
				table.insert(helperTable.title, tostring(g_helperManager.indexToHelper[a].name));
				table.insert(helperTable.xmlFile, tostring(g_helperManager.indexToHelper[a].modelFilename));
				table.insert(helperTable.index, tonumber(g_helperManager.indexToHelper[a].index));			
			end;
			function table.removeKey(t, k_to_remove)
			  local new = {};
			  for k, v in pairs(t) do
				new[k] = v;
			  end
			  new[k_to_remove] = nil;
			  return new;
			end;		
			for a=1, #helperTable.oldName do
				for k, v in pairs(g_helperManager.helpers) do
					if helperTable.oldName[a] == k then									
						local indexHelper = v.index;					
						g_helperManager.nameToIndex = table.removeKey(g_helperManager.nameToIndex, k);					
						g_helperManager.nameToIndex[tostring(hString).. string.upper(helperName[a])] = indexHelper;					
						g_helperManager.availableHelpers[indexHelper].name = string.upper(helperName[a]);
						g_helperManager.availableHelpers[indexHelper].title = string.upper(helperName[a]);
						g_helperManager.indexToHelper[indexHelper].name = string.upper(helperName[a]);
						g_helperManager.indexToHelper[indexHelper].title = string.upper(helperName[a]);
						g_helperManager.helpers = table.removeKey(g_helperManager.helpers, string.gsub(helperTable.oldName[a], hString, ""));
						g_helperManager.helpers[helperName[a]] = {title=string.upper(helperName[a]),name=string.upper(helperName[a]),modelFilename=helperTable.xmlFile[a],index=helperTable.index[a]};
					end;
				end;
			end;
		end;
		for a=11, g_currentMission.maxNumHirables do
			if helperName[a] ~= nil then				
				if a <= 20 then
					HiredHelperTool:addHelper(tostring(helperName[a]), tostring(string.upper(helperName[a])), {1, 1, 1}, tostring(g_helperManager.indexToHelper[a-10].modelFilename), nil, true);
				elseif a > 20 and a <= 30 then --default 30	
					HiredHelperTool:addHelper(tostring(helperName[a]), tostring(string.upper(helperName[a])), {1, 1, 1}, tostring(g_helperManager.indexToHelper[a-20].modelFilename), nil, true);
				elseif a > 30 and a <= 40 then --max 40	
					HiredHelperTool:addHelper(tostring(helperName[a]), tostring(string.upper(helperName[a])), {1, 1, 1}, tostring(g_helperManager.indexToHelper[a-30].modelFilename), nil, true);
				elseif a > 40 and a <= 50 then --max 50	etc. etc.
					HiredHelperTool:addHelper(tostring(helperName[a]), tostring(string.upper(helperName[a])), {1, 1, 1}, tostring(g_helperManager.indexToHelper[a-40].modelFilename), nil, true);
				end;
			else
				HiredHelperTool.errorTable = true;
				g_currentMission.maxNumHirables	= oldMaxNumHirables;				
				break;
			end;
		end;		
		if HiredHelperTool.errorTable then print("---Script HiredHelperTool Error !!!(helperName Table length corrupt)---");return false;end;
		if g_helperManager.numHelpers < #g_helperManager.availableHelpers then g_helperManager.numHelpers = #g_helperManager.availableHelpers;end;
	else
		HiredHelperTool.errorTable = true;
		print("---Script HiredHelperTool Error !!!(not found MissionsData/HelperManager)---");
	end;	
end;

function HiredHelperTool:deleteMap()
end;

function HiredHelperTool:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HiredHelperTool:keyEvent(unicode, sym, modifier, isDown)	
end;

function HiredHelperTool:update(dt)	
	if not HiredHelperTool.errorTable then
		if g_currentMission.maxNumHirables ~= g_helperManager.numHelpers then --for secureness
			g_currentMission.maxNumHirables = g_helperManager.numHelpers;						
		end;
	end;
end;

function HiredHelperTool:draw(dt)
end;
addModEventListener(HiredHelperTool);

function HiredHelperTool:addHelper(name, title, color, modelFilename, baseDir, isBaseType)
    name = name:upper();
    if isBaseType and g_helperManager.nameToIndex[name] ~= nil then
        print(tostring(HiredHelperTool.metadata.title).. " Warning: Helper '"..tostring(name).."' already exists. Ignoring helper!")
        return nil;
    end
    local helper = g_helperManager.helpers[name];
    if helper == nil then
        if modelFilename == nil or modelFilename == "" then
            print(tostring(HiredHelperTool.metadata.title).. " Warning: Missing helper config file for helper '"..tostring(name).."'. Ignoring helper!")
            return nil;
        end
        g_helperManager.numHelpers = g_helperManager.numHelpers + 1;
        helper = {}
        helper.name = name;
        helper.index = g_helperManager.numHelpers;
        helper.title = name;
        helper.color = color;
		if title ~= nil then
            helper.title = g_i18n:convertText(title);
        end
        helper.modelFilename = Utils.getFilename(modelFilename, baseDir);
        g_helperManager.helpers[name] = helper;
        g_helperManager.nameToIndex[name] = g_helperManager.numHelpers;
        g_helperManager.indexToHelper[g_helperManager.numHelpers] = helper;
        table.insert(g_helperManager.availableHelpers, helper);
    else
        if title ~= nil then
            helper.title = g_i18n:convertText(title)
        end
        if modelFilename ~= nil then
            helper.modelFilename = Utils.getFilename(modelFilename, baseDir)
        end
    end
    return helper
end